;additional vector useful functions

(define (vector-head vec len)
       (let ((new-vec (make-vector len)))
            (container-replace! new-vec vec 0)))

(define (vector-append . items)
   (let* ((len (fold + 0 (map vector-length items)))
          (vec (make-vector len)))
	(let loop ((start 0)
                   (items items))
          (if (null? items)
              vec
              (loop (container-replace! vec (car items) start)
                    (cdr items))))))

(define (vector-resize len . fill-symbol)
  (if (vector? vec)
      (let ((actual-len (vector-length vec)))
        (if (< actual-len len)
            (vector-append vec (apply make-vector (- len actual-len) fill-symbol))
            (vector-head lst len)))
      (vector-append (make-vector vec) (apply make-vector (- len 1) fill-symbol))))
