;description: adapter for old style woobus modules (external processes)

(define (compat-read-process-answer ports)
  (read-bus-address ports
		    (forward-address
		      (cons forward-address
			    (message->commands (read-bus-message ports))))
		    (backward-address
		      (cons backward-address
			    (message->commands (read-bus-message ports))))))

(define (compat-empty-default cmd-pair) cmd-pair)

(define (command<->process addr cmd-pair next default ports)
  (define (with-prefix lst) (cons (car cmd-pair) lst))
  
  (if (write-bus addr (commands->message (cdr cmd-pair)) ports)
    (let ((result (compat-read-process-answer ports))) ; if message was accepted 'then wait for the answer
      (cond
	((string=? (car result) forward-address)
	 (command<->process '<< (next (with-prefix (cdr result)))
			    next
			    compat-empty-default
			    ports))
	((string=? (car result) backward-address)
	 (with-prefix (cdr result)))
	(else
	  (error "unknown address:" (car result)))))
  (default cmd-pair)))
      
(define (external-main cmd-pair next ports)
  (command<->process '>> cmd-pair next 
		    (lambda (cmd-pair)
		      (command<->process '<< (next cmd-pair)
					 next
					 compat-empty-default
					 ports))
		    ports))

(define (external command . args)
  (let ((ports (apply create-process 'read-write  command args)))
    (lambda (cmd-pair next)
      (external-main cmd-pair next ports))))

