;description: support for old style woobus interactity: pass commands throw stdin/stdout

;made quote transform for the single character
(define (command-char-quote ch)
  (case ch
    ((#\:) "$%")
    ((#\$) "$$")
    ((#\newline) "$n")
    (else (string ch))))

;made reverse transform for char after escape symbol
(define (command-char-unquote ch)
  (case ch
    ((#\%) ":")
    ((#\$) "$")
    ((#\n) (string #\newline))
    (else (string ch))))

;made command specific quote transformation for the string
(define (command-string-quote str) (string-quote command-char-quote str))

;made reverse transform for the string
(define (command-string-unquote str)
  (define trivial-translate (lambda (x) (string x)))
  (string-unquote #\$ command-char-unquote trivial-translate str))

;output using old format for the (name,value) option pair
(define (write-command-arg name value port)
  (display #\+ port)
  (display (command-string-quote (sure-string name)) port)
  (display #\: port)
  (display (command-string-quote (sure-string value)) port)
  (newline port))

;ouput using old format for the command name
(define (write-command-name name port)
  (display #\% port)
  (display (command-string-quote (sure-string name)) port)
  (newline port))

;ouput command to current-output-port in the old format
(define (write-command cmd . arg)
  (let ((port (if (null? arg) (current-output-port) (car arg))))
    (write-command-name (command-name cmd) port)
    (command-for-each
      (lambda (name value) (write-command-arg name value port))
      cmd)
    (display #\# port)
    (newline port)))

(define (string->command-arg str)
  (let ((separator (string-index str #\:)))
    (or separator 
	(error "unable to find ':' separator in option"))
    (list (string->symbol 
	    (command-string-unquote (substring str 0 separator)))
	  (command-string-unquote (substring str (+ 1 separator) (string-length str))))))
 
;create command-name from string
(define (string->command-name str)
  (string->symbol (command-string-unquote str)))

;read command from current-input-port
;TODO: parse args and unquote strings
(define (read-command . arg)
  (let ((port (if (null? arg) (current-input-port) (car arg))))
    (let loop ((cmd '())
	       (line (read-line port)))
      (cond 
	((eof-object? line) cmd)
	((zero? (string-length line)) (loop cmd (read-line port))) ;ignore empty lines
	(else
	  (case (string-ref line 0)
	    ((#\%) (loop (if (null? cmd) 
			   (list (string->command-name
				   (substring line 1 (string-length line)))) 
			   cmd)
			 (read-line port)))
	    ((#\+) (if (null? cmd) (error "options without command name")
		     (loop (append 
			     cmd
			     (string->command-arg
			       (substring line 1 (string-length line))))
			   (read-line port))))
	    ((#\#) cmd)
	    (else (loop cmd (read-line port))))))))) ;ignore unknown line types

(define (read-command-list . arg)
  (let ((port (if (null? arg) (current-input-port) (car arg))))
    (let loop ((result '())
	       (cmd (read-command port)))
      (if (null? cmd)
	result
	(loop (append1 result cmd)
	      (read-command port))))))

