(define read-ports '())
(define write-ports '())
(define except-ports '())


(define (add-read-port port thunk)
  (set! read-ports (acons port thunk read-ports)))

(define (remove-read-port port)
  (set! read-ports (alist-delete port read-ports)))

(define (find-handler port lst)
  (cdr (assoc port lst)))

(define (execute-handler handler)
  (handler))

(define (selector)
  (let ((result (select
                 (map car read-ports)
                 (map car write-ports)
                 (map car except-ports))))
    (for-each execute-handler
              (concatenate
               (map
                (lambda(select-ports exist-ports)
                  (map (lambda (port)
                         (find-handler port exist-ports))
                       select-ports))
                result
                (list read-ports write-ports except-ports))))))


(define (selector-loop)
  (selector)
  (selector-loop))
