(define-module (alterator transport jabber-channel)
    :use-module (alterator str)
    :use-module (alterator algo)
    :export(jabber-in))

(dynamic-call "scm_init_loudmouth" (dynamic-link "libguile-loudmouth.so"))

(define (jabber-in-main cmd-pair next server user password)
    (define (cb msg)
      (let* ((cmd (with-input-from-string msg
                   (thunk (read))))
             (answer (next (cons cmd (list cmd)))))
        (format #t "input-message:~A~%output-message:~A~%" cmd (cdr answer))
        (format #f "~S" (cdr answer))))
    (lm-listen server user password cb))
      
(define (jabber-in jid password)
  (let ((server-user (string-cut jid #\@)))
    (lambda (cmd-pair next)
      (jabber-in-main cmd-pair next (cadr server-user) (car server-user) password))))
