#include <libguile.h>
#include <loudmouth/loudmouth.h>
#include <stdio.h>
#include <string.h>


typedef struct {
  const char *name;
  const char *passwd;
} UserInfo;

typedef struct {
  char * (*cb)(const char*,void*);
  void *user_data;
} CallbackInfo;

static void
authentication_cb (LmConnection *connection, gboolean result, gpointer ud)
{
  if (result == TRUE)
    {
      LmMessage *m = lm_message_new_with_sub_type (NULL,
						   LM_MESSAGE_TYPE_PRESENCE,
						   LM_MESSAGE_SUB_TYPE_AVAILABLE);
      lm_connection_send (connection, m, NULL);
      lm_message_unref (m);
    }
  else
      printf("authentication failed");
}

static void
connection_open_cb (LmConnection *connection, gboolean result, UserInfo *info)
{
  if (result == TRUE)
    {
      lm_connection_authenticate (connection,
				  info->name, info->passwd, "alterator",
				  authentication_cb, NULL,FALSE,  NULL);
    }
  else
      printf("connection failed");

  free(info);
}

static
LmMessage *make_message(const char *from,char* body)
{
  LmMessage *m = lm_message_new(from,LM_MESSAGE_TYPE_MESSAGE);
  lm_message_node_add_child(m->node,"body",body);
  return m;
}

static LmHandlerResult
handle_messages (LmMessageHandler *handler,
		 LmConnection     *connection,
		 LmMessage        *m,
		 CallbackInfo *data)
{
  LmMessageNode *node = lm_message_node_find_child (m->node, "body");
  if (node)
    {
      char *cb_result = data->cb(lm_message_node_get_value(node),data->user_data);
      LmMessage* answer =  make_message(lm_message_node_get_attribute(m->node,"from"),
					cb_result);
      lm_connection_send(connection,answer,NULL);
      lm_message_unref(answer);
      free(cb_result);
    }
  
  return LM_HANDLER_RESULT_REMOVE_MESSAGE;
}

void 
lm_listen(const char *server,
          const char *user,
	  const char *password,
	  CallbackInfo *cb_data)
{

  GMainLoop        *main_loop;
  LmConnection     *connection;
  LmMessageHandler *handler;
  gboolean          result;
  UserInfo         *info;
  
  connection = lm_connection_new (server);
  
  handler = lm_message_handler_new ((LmHandleMessageFunction)handle_messages,
                                     cb_data, NULL);
  lm_connection_register_message_handler (connection, handler, 
					  LM_MESSAGE_TYPE_MESSAGE, 
					  LM_HANDLER_PRIORITY_NORMAL);
  
  lm_message_handler_unref (handler);
  
  info = (UserInfo*)malloc(sizeof(UserInfo));
  info->name = user;
  info->passwd = password;
  
  result = lm_connection_open (connection,
			       (LmResultFunction) connection_open_cb,
			       info, NULL, NULL);
  
  if (!result) return;
  
  main_loop = g_main_loop_new (NULL, FALSE);
  g_main_loop_run (main_loop);
  
}

SCM str2scm(const char *str) { return scm_from_locale_stringn(str?str:"",str?strlen(str):0); }

//static
char *scm_cb(const char *msg,void *scm_callback)
{
  return scm_to_locale_string(scm_call_1((SCM)(scm_callback),str2scm(msg)));
}


SCM scm_lm_listen(SCM server,
		  SCM user,
		  SCM password,
		  SCM callback)
{
  CallbackInfo *cb_data = malloc(sizeof(CallbackInfo));
  const char *s_server = scm_to_locale_string(server);
  const char *s_user = scm_to_locale_string(user);
  const char *s_password = scm_to_locale_string(password);
  
  cb_data->cb = scm_cb;
  cb_data->user_data = callback;
  lm_listen(s_server,s_user,s_password,cb_data);

  free(cb_data); 
  free((void*)s_server);
  free((void*)s_user);
  free((void*)s_password);
  
  return SCM_UNSPECIFIED;
}


void scm_init_loudmouth(void)
{
        scm_c_define_gsubr("lm-listen", 4, 0, 0,
                           (SCM (*)())scm_lm_listen);
}


#if 0
char *msg_cb(const char* msg)
{
  printf("getting message:%s\n",msg);
  return strdup(msg);
}

int main(int argc,char **argv)
{
  lm_listen(argv[1],argv[2],argv[3],msg_cb);
}
#endif
