#include <pty.h>  /* for openpty and forkpty */
#include <sys/ioctl.h>
#include <unistd.h>

#include <libguile.h>

SCM scm_make_pty()
{
	int master = -1, slave = -1;
	
	if (openpty(&master, &slave, 0, 0, 0) < 0)
		return SCM_BOOL_F;
	else
	{
		return scm_cons(scm_int2num(master),scm_int2num(slave));
	}
}
	     
SCM scm_set_controlling_terminal(SCM obj)
{
	int fd = scm_num2int(obj, SCM_ARG1, "set_controlling_terminal");
	
	setsid();
	if (ioctl(fd, (unsigned long) TIOCSCTTY, 0) < 0)
		return SCM_BOOL_F;
	else
		return SCM_BOOL_T;
}

void scm_init_terminal(void)
{
	scm_c_define_gsubr("make-pty", 0, 0, 0,(SCM (*)())scm_make_pty);
	scm_c_define_gsubr("set-controlling-terminal", 1, 0, 0,(SCM (*)())scm_set_controlling_terminal);
}
