(define untrusted-env (scheme-report-environment 5))

(define (protect-untrusted exp)
  (define lst '(call-with-input-file call-with-output-file
                 with-input-from-file with-output-to-file
                 open-input-file  open-output-file
                 close-input-port close-output-port
                 load eval))
  `(let ,(map (lambda(x) `(,x #f)) lst) ,exp))

(define (bind-to-untrusted function real-function)
  (let ((gate
         (eval `(begin (define ,function
                         (call-with-current-continuation (lambda(x) x)))
                       ,function)
               untrusted-env)))
    (or (eq? gate real-function)
        (gate real-function))))

;;gate to security monitor
(bind-to-untrusted '*security-monitor* security-monitor)

(define-macro (security-requires . lst)
  `(begin ,@(map (lambda(x) `(define ,x (*security-monitor* ',x)))
                 lst)))

;;helper to extract funtions from monitor
(bind-to-untrusted 'requires security-requires)


(define (untrusted-eval exp)
        (eval (protect-untrusted exp)
                                 untrusted-env))
