
UI_TARGETS=$(wildcard ui/*.scm)

MAP_FILES=$(wildcard ui/*.map.in)
SMAP_FILES=$(wildcard ui/*.smap.in)
MAP_TARGETS=$(MAP_FILES:%.map.in=%.map)
SMAP_TARGETS=$(SMAP_FILES:%.smap.in=%.smap)

LAYOUT_TARGETS=$(wildcard ui/*.layout)

datadir = /usr/share

ALTERATOR_DATADIR=$(datadir)/alterator
ALTERATOR_LAYOUT_DIR=$(ALTERATOR_DATADIR)/layouts
ALTERATOR_MAP_DIR=$(ALTERATOR_DATADIR)/maps
ALTERATOR_UI_DIR=$(ALTERATOR_DATADIR)/ui/$(UI_SUBDIR)/

build-ui: $(MAP_TARGETS) $(SMAP_TARGETS)

install-ui:build-ui
	$(INSTALL) -d $(ALTERATOR_LAYOUT_DIR)
	$(INSTALL) -d $(ALTERATOR_MAP_DIR)
	$(INSTALL) -d $(ALTERATOR_UI_DIR)
	for i in $(MAP_TARGETS) $(SMAP_TARGETS) ; do  \
	$(INSTALL) -pm644 $$i $(ALTERATOR_MAP_DIR)/`basename $$i` ; \
	done
	for i in $(UI_TARGETS) ; do \
	$(INSTALL) -pm644 $$i $(ALTERATOR_UI_DIR)/`basename $$i` ; \
	done
	for i in $(LAYOUT_TARGETS) ; do  \
	$(INSTALL) -pm644 $$i $(ALTERATOR_LAYOUT_DIR)/`basename $$i` ; \
	done

clean-ui:
	$(RM) ui/*.map
	$(RM) ui/*.smap

ui/%.map:ui/%.map.in
	sed -e 's,@UIDIR@,$(ALTERATOR_UI_DIR),g' <$< >$@

ui/%.smap:ui/%.smap.in
	sed -e 's,@UIDIR@,$(ALTERATOR_UI_DIR),g' <$< >$@

