;Qt interface driver for lookout

(dynamic-call "scm_init_qt_look" (dynamic-link "libguile-qtlook.so"))

(use-modules (alterator lookout common)
             (alterator object))

;TODO: rewrite to new look
;(define (qt-tabbox-dispatcher widget command . args)
;  (define (sure-procedure x)
;    (cond
;      ((procedure? x) x)
;      ((symbol? x) (eval x (current-module)))
;      (else (error "unknown type to conversion" x))))
;  (case command
;    ((set) (let ((subcommand (car args))
;		 (subargs (cdr args)))
;	     (case subcommand
;	       ((tab-panel) (widget-set-extra widget "add-tab"
;					      (car subargs) ;label
;					      "" ; unused
;					      ((cadr subargs) 'get-widget)))
;	       ((current)
;		(widget-set-attr widget "current" ((sure-procedure (car subargs)) 'get-widget)))
;	       (else
;		 (apply qt-widget-dispatcher widget command args)))))
;    ((get) (let ((subcommand (car args))
;		 (subargs (cdr args)))
;	     (case subcommand
;	       ((current)
;		(sure-procedure
;		  (widget-get-attr widget
;				   "current")))
;	       (else
;		 (apply qt-widget-dispatcher widget command args)))))
;    (else
;      (apply qt-widget-dispatcher widget command args))))


;TODO: rewrite to new look
;enhanced dipatcher for qt listbox/combobox (with range support)
;(define (qt-listbox-dispatcher widget command . args)
;  (define (add-item item)
;    (widget-set-extra widget "append"
;		      (sure-string (if (pair? item) (car item) item))
;		      (sure-string (if (pair? item) (cdr item) ""))
;		      ""))
;
;  (define (change-item widget attr value number)
;    (widget-set-extra widget "edit"
;		      (sure-string attr)
;		      (sure-string value)
;		      number))
;  (case command
;    ((set) (let ((subcommand (car args))
;		 (subargs (cdr args)))
;	     (case subcommand
;	       ((items) (widget-set-attr widget "remove" 'all)
;			(map add-item (car subargs)))
;	       ((append-item) (add-item (car subargs)))
;	       ((remove) (if (eq? (car subargs) 'all)
;			   (widget-set-attr widget "remove" 'all)
;			   (for-range (lambda (x) (widget-set-attr widget "remove" x))
;				      subargs)))
;	       ((item-pixmap) (for-range (lambda (x) (change-item widget "pixmap" (car subargs) x))
;					 (cdr subargs)))
;	       ((item-text) (for-range (lambda (x) (change-item widget "text" (car subargs) x))
;				       (cdr subargs)))
;	       (else (widget-set-attr widget 
;				      (sure-string subcommand)
;				      (car subargs))))))
;    ((get) (let ((subcommand (car args))
;		 (subargs (cdr args)))
;	     (case subcommand
;	       ((item-text) (widget-get-extra widget "text" (car subargs)))
;	       (else (widget-get-attr widget
;				      (sure-string subcommand))))))
;    (else (apply qt-widget-dispatcher widget command args))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-qt-default-widget widget)
  (object
    <qt-default-widget>
    ((get self name) (widget-get-attr widget (sure-string name)))
    ((set self name value) (widget-set-attr widget
					    (sure-string name)
					    value))))

(define (make-qt-dialog widget)
  (join
     <qt-dialog>
    (object
      <qt-basic-dialog>
      ((start self) (widget-start widget))
      ((stop self) (widget-stop widget)))
    (make-qt-default-widget widget)))


(define (make-qt-widget constructor . rest)
  (lambda (eventholder parent-widget)
    (let ((callable-holder (callable eventholder)))
      (let* ((widget (constructor  callable-holder (and parent-widget (parent-widget 'get-widget))))
	     (mixed-object (if (null? rest)
			     (make-qt-default-widget widget)
			     ((car rest) widget))))
	(join
	  <qt-widget>
	  (object
	    <qt-basic>
	    ((get-widget self) widget)
	    ((delete self) (delete-widget widget)))
	  mixed-object)))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;driver description
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(declare-widget dialog (make-qt-widget dlg-make-dialog make-qt-dialog))
(declare-widget button (make-qt-widget dlg-make-button) text)
(declare-widget label (make-qt-widget dlg-make-label) text)
(declare-widget edit (make-qt-widget dlg-make-lineedit) text)
(declare-widget vbox (make-qt-widget dlg-make-vbox))
(declare-widget hbox (make-qt-widget dlg-make-hbox))
(declare-widget splashscreen (make-qt-widget dlg-make-splashscreen))
(declare-widget checkbox (make-qt-widget dlg-make-checkbox) text)
(declare-widget groupbox (make-qt-widget dlg-make-groupbox) title)
(declare-widget progressbar (make-qt-widget dlg-make-progressbar))
(declare-widget textbox (make-qt-widget dlg-make-textbox) text)
(declare-widget scrollview (make-qt-widget dlg-make-scrollview))

;(declare-widget listbox (make-qt-widget dlg-make-listbox qt-listbox-dispatcher))
;(declare-widget combobox (make-qt-widget dlg-make-combobox qt-listbox-dispatcher))
;(declare-widget tabbox (make-qt-widget dlg-make-tabbox qt-tabbox-dispatcher))

;wrapper over tab-panel
;insert widgets and generate also tab-panel attribute
;(define (tab tab-id tab-label . widgets)
;  (let ((vb (id tab-id (apply vbox widgets))))
;   `(,vb ,(tab-panel tab-label (cadr vb)))))

(declare-application-constructor make-qt-application)
(declare-application-destructor delete-qt-application)
(declare-application-runner (lambda() (document:popup "/")))

(declare-popup-widget (make-qt-widget dlg-make-dialog make-qt-dialog))
(declare-root-widget (make-qt-widget dlg-make-vbox))
