/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef DIALOG_QT_HH
#define DIALOG_QT_HH

#include <string>
#include <iostream>

#include <qlayout.h>
#include <qtimer.h>

#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qsplashscreen.h>
#include <qgroupbox.h>
#include <qtabwidget.h>
#include <qprogressbar.h>
#include <qscrollview.h>

#include <qdialog.h>
#include <qcursor.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <dbus/connection.h>

#include <shared_ptr.hh>

#include <libguile.h>

//Note: I need QObject inheritanse for correct deffered object deletion
// cause I need to destruct objects from it's callbacks
class qt_widget: public QObject
{
	Q_OBJECT
	SCM data_;
	void call_event_holder(const std::string&);
public:
	qt_widget(SCM data);
	virtual ~qt_widget();
	virtual SCM get_attr(const std::string& name);
	virtual void set_attr(const std::string&, SCM);

	virtual void set_extra(const std::string&,const std::string&,
					  	  const std::string&,
					 	  SCM) {}

	virtual SCM get_extra(const std::string&,SCM)
	{return SCM_UNSPECIFIED;}

	virtual QWidget *get_widget(void) const = 0;
public slots:
	void on_click(void) { call_event_holder("on-click"); }
	void on_change(void) { call_event_holder("on-change"); }
	void on_change(const QString&) { call_event_holder("on-change"); }
	void on_change(QWidget*) { call_event_holder("on-change"); }
	void on_return() { call_event_holder("on-return"); }
	void on_select() { call_event_holder("on-select"); }
	void on_double_click() { call_event_holder("on-double-click"); }
	void on_toggle(bool) { call_event_holder("on-toggle"); }

//delayed versions
	void delayed_on_select()
	{
		QTimer::singleShot(0,this, SLOT(on_select()));
	}
	void delayed_on_double_click(QListBoxItem* item)
	{
		QTimer::singleShot(0,this, SLOT(on_double_click()));
	}
	void delayed_on_change(const QString&)
	{
		QTimer::singleShot(0,this, SLOT(on_change()));
	}
};

void widget_corners_round(QWidget *widget);

//hack to access protected done() slot
//also ignore escape button press and some other features
class QDialog2: public QDialog
{
public:
	QDialog2(QWidget *parent = 0): QDialog(parent)
	{
		setWFlags(Qt::WType_Dialog|Qt::WShowModal);
	}
	void done() { QDialog::done(0); }
private:
	void keyPressEvent ( QKeyEvent * e ) 
	{
		if ((e->key() != Key_Escape) && 
		    (e->key() != Key_Enter) &&
		    (e->key() != Key_Return))
			QDialog::keyPressEvent(e);
	}
	void showEvent(QShowEvent *e)
	{
		QDialog::showEvent(e);
    		QCursor::setPos(mapToGlobal(QPoint(width()/2, height()/2)));
	}
	void paintEvent(QPaintEvent* e)
	{
//		QDialog::paintEvent(e);
    		widget_corners_round(this);
	}
};

//hack to access protected deleteAllItems() slot
class QHBoxLayout2: public QHBoxLayout
{
public:
	QHBoxLayout2(QWidget *parent = 0): QHBoxLayout(parent)
	{}
	void deleteAllItems() { QHBoxLayout::deleteAllItems(); }
};

//hack to access protected deleteAllItems() slot
class QVBoxLayout2: public QVBoxLayout
{
public:
	QVBoxLayout2(QWidget *parent = 0): QVBoxLayout(parent)
	{}
	void deleteAllItems() { QVBoxLayout::deleteAllItems(); }
};

//I want to have hibrid of QLabel (pixmap engine) and QFrame (correct work in layouts)
class QLabel2: public QLabel
{
public:
	QLabel2(QWidget *parent):QLabel(parent)
	{
		setScaledContents(true);
	}
	virtual QSize sizeHint() const
	{
		return QFrame::sizeHint();
	}
};

#define ATTRIBUTE_FUNCTIONS \
	virtual void set_attr(const std::string&,SCM); \
	virtual SCM get_attr(const std::string& name);

#define BEGIN_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
	class qt_##CLASSNAME: public qt_widget \
	{ \
		alt::shared_ptr<QTWIDGET> wnd; \
	public: \
		qt_##CLASSNAME(SCM data,qt_widget *parent=0); \
		virtual QWidget *get_widget(void) const { return wnd; }

#define END_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
	};

#define DECLARE_QT_WIDGET(QTWIDGET,CLASSNAME) \
	BEGIN_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
		ATTRIBUTE_FUNCTIONS \
	END_CLASS_DECLARATION(QTWIDGET,CLASSNAME)


//single widgets
DECLARE_QT_WIDGET(QPushButton,button)
DECLARE_QT_WIDGET(QLabel,label)
DECLARE_QT_WIDGET(QLineEdit,lineedit)
DECLARE_QT_WIDGET(QTextEdit,textbox)
DECLARE_QT_WIDGET(QCheckBox,checkbox)
DECLARE_QT_WIDGET(QGroupBox,groupbox)
DECLARE_QT_WIDGET(QProgressBar,progressbar)
DECLARE_QT_WIDGET(QLabel2,vbox)
DECLARE_QT_WIDGET(QLabel2,hbox)
DECLARE_QT_WIDGET(QSplashScreen,splashscreen)
DECLARE_QT_WIDGET(QTabWidget,tabbox)

//special for scrollview
BEGIN_CLASS_DECLARATION(QWidget, scrollview)
	ATTRIBUTE_FUNCTIONS
	private:
	    QScrollView *scroll;
END_CLASS_DECLARATION(QListBox,listbox)

//special for listbox
BEGIN_CLASS_DECLARATION(QListBox,listbox)
	virtual void set_extra(const std::string&,const std::string&,
					  	  const std::string&,
					  	  SCM);
	virtual SCM get_extra(const std::string&,SCM);
	ATTRIBUTE_FUNCTIONS
END_CLASS_DECLARATION(QListBox,listbox)

//special for combobox
BEGIN_CLASS_DECLARATION(QComboBox,combobox)
	virtual void set_extra(const std::string&,const std::string&,
					  	  const std::string&,
					  	  SCM);
	virtual SCM get_extra(const std::string&,SCM);
	ATTRIBUTE_FUNCTIONS
END_CLASS_DECLARATION(QCombobox,combobox)


//special for dialog
BEGIN_CLASS_DECLARATION(QDialog2,dialog)
	void start();
	void stop();
	ATTRIBUTE_FUNCTIONS
END_CLASS_DECLARATION(QDialog2,dialog)


//////////////////// initialization functions
void scm_init_qt_application();
void scm_init_qt_widgets();

void init_qt_dbus(DBusBusType type);
extern SCM qt_dbus_handler;

extern scm_t_bits widget_tag;

////////////////// Scheme <-> C conversions
	SCM bool2scm (int);
	int scm2bool (SCM);

	SCM str2scm(const char *str);
        const char *scm2str(SCM obj);

	SCM num2scm(int num);
	int scm2num(SCM obj);

	SCM symbol2scm(const char *str);
	const char *scm2symbol(SCM obj);

#endif // DIALOG_QT_HH
