(document:surround "/std/base")


(define (users)
  (items (woo-read-names "/users" (woo-list "/users"))))


(define (user name)
  (woo-first-command (woo-read (string-append "/users/" name))))

(define (command->fields cmd . fields)
  (define-operation get-id)
  (for-each (lambda (field)
              (cond
               ((command-arg-ref cmd (get-id field)) => (lambda(x) (field text (cdr x))))))
            fields))


(groupbox "Users:"
          (layout-policy 100 80)
          (hbox
           (layout-policy 100 100)
           (document:id userlist
                        (listbox (users)
                                 (layout-policy 50 100)
                                 (on-select
                                  (command->fields (user (userlist text))
                                                   uid gid home gecos))))
           (vbox
            (layout-policy 50 100)
            (hbox (layout-policy 100 25)
                  (label "UID:" (layout-policy 50 -1))
                  (document:id uid (edit "some uid" (layout-policy 50 -1))))
            (hbox (layout-policy 100 25)
                  (label "GID:" (layout-policy 50 -1))
                  (document:id gid (edit "some gid" (layout-policy 50 -1))))
            (hbox (layout-policy 100 25)
                  (label "HOME:" (layout-policy 50 -1))
                  (document:id home (edit "some home" (layout-policy 50 -1))))
            (hbox (layout-policy 100 25)
                  (label "GECOS:" (layout-policy 50 -1))
                  (document:id gecos (edit "some gecos" (layout-policy 50 -1)))))))
          

(button "Quit"
        (layout-policy 100 20 center)
        (on-click (document:end)))
	