// ConcordSimple.cpp : Defines the entry point for the 



#include <time.h>

#include "../ConcordLib/ConcHolder.h"
#include "../common/util_classes.h"


void PrintHelp()
{
		
	printf ("load <Concordance Project>  - load project\n");
	printf ("query <query> - run a query\n");
	printf ("set limit <limit> - maximal count of hits to find\n");
	printf ("set profile_cycle <count> - how many times should the program run the query\n");
	printf ("set out <file> - print hits to <file> \n");
	printf ("set result_format html|txt|table - set the format of hits\n");
	printf ("exit - exit\n");
	printf ("showtime - toggle show time switcher\n");
	printf ("echoquery - toggle echo query switcher\n");
	
	

};

CConcHolder Holder;
size_t CountOfCycles = 1;
bool bShowTime = true;
bool bEchoQuery = true;
string OutFile = "";

void FreeCorpus()
{
	if (Holder.m_pIndexator)
	{
		delete Holder.m_pIndexator;
	    Holder.m_pIndexator = 0;
	};
};

bool LoadCorpus(string FileName)
{

	Trim(FileName);
	if (FileName.empty())
	{
		printf("cannot load from empty corpus\n");
		return false;
	}
	FreeCorpus();
	Holder.m_pIndexator = new CConcIndexator;

	if (!Holder.m_pIndexator->LoadProject(FileName.c_str()))
	{
		fprintf (stderr, "cannot load project %s\n", FileName.c_str());
		return false;
	};
		
	return true;
};

void ExitFromProgram()
{
	FreeCorpus();
	FreeConcordDicts();
	exit(0);
};

void RussianConvertToDictionary (string& S)
{
	#ifdef WIN32
		OemToCharBuff((char*)S.c_str(), (char*)S.c_str(), S.length());		
	#else
		KOI8ToWin(S);
	#endif

};

void RussianConvertToScreen (string& S)
{
	#ifdef WIN32
		CharToOemBuff((char*)S.c_str(), (char*)S.c_str(), S.length());		
	#else
		WinToKOI8(S);
	#endif

};

void RunQuery(string Command, string Query)
{
	Trim(Query);
	if (Query.empty())
	{
		printf ("cannot process empty query\n");
		return;
	};		
	if (!Holder.m_pIndexator)
	{
		printf ("no loaded corpus\n");
		return;
	};		

	if (CountOfCycles > 1)
		printf ("Count of profile cycles = %i\n", CountOfCycles);

	DWORD  EndHitNo = 0, HitsCount;		
		

	time_t t1;
	time(&t1);
	DDCErrorEnum Error;

	for (int ProfileCycleNo=0; ProfileCycleNo < CountOfCycles; ProfileCycleNo++)
	{
	
			EndHitNo = 0;

			Error =  Holder.SimpleQuery(Query.c_str(), EndHitNo, HitsCount);

			if (Error != errUnknown)
			{
				fprintf (stderr, "Error! %s \n", GetDDCErrorString(Error).c_str());
				return;
			};

			if (ProfileCycleNo > 0)
				Holder.ClearQueryCache();

	};
		
		

	time_t t2;
	time(&t2);
	string s = Holder.m_QueryResultStr;
	if (OutFile.empty())
	{
		if (Holder.m_pIndexator->m_Language == morphRussian)
			RussianConvertToScreen(s);
		
		printf ("%s", s.c_str());
	}
	else
	{
		FILE * fp =  fopen (OutFile.c_str(),"a");
		if (!fp)
		{
			fprintf (stderr, "cannot open  %s\n", OutFile.c_str());
		}
		else
		{
			fprintf (fp, "%s\n", s.c_str());
			fclose (fp);
		};
	};
	

	printf ("HitsCount = %i\n", HitsCount);
	if (bShowTime)
		fprintf (stderr, "Seconds = %i\n", t2 - t1);

};


void RunCommand(string line)
{
	Trim(line);
	if (line  == "exit") ExitFromProgram();
	if (line  == "showtime") 
	{
		bShowTime = !bShowTime;
		printf ("ShowTime = %s\n", bShowTime? "true":  "false");
	};
	if (line  == "echoquery") 
	{
		bEchoQuery = !bEchoQuery;
		printf ("EchoQuery = %s\n", bEchoQuery? "true":  "false");
	};
	
	
	if (line  == "help")
	{
		PrintHelp();
		return;
	};
	StringTokenizer tok(line.c_str(), " ");
	string command = tok.next_token();
	if (command.empty()) return;
	if (command == "load")
			LoadCorpus(tok.next_token());
	else
	if (command == "query")
		RunQuery(command,line.substr(line.find(" ")) );
	else
	if (command == "set")
	{
		string variab = tok.next_token();
		string value = tok.next_token();
		if (value.empty()) return;
		if (variab == "profile_cycle")
			{
				CountOfCycles = atoi(value.c_str());
				printf ("Count of profile cycles = %i\n", CountOfCycles);
				
			}
		else
 		 if (variab == "limit")
			{
		 		Holder.m_ResultLimit = atoi(value.c_str());
				fprintf  (stderr, "ResultLimit = %i\n", Holder.m_ResultLimit);
			}
		else
 		 if (variab == "out")
		 {
			 OutFile = value.c_str();
			 if (OutFile == "stdout")
				 OutFile = "";
		 }
		else
 		 if (variab == "result_format")
		 {
			 Holder.SetResultFormat(value);
			 fprintf  (stderr, "result format = %s\n", Holder.GetResultFormatStr().c_str());
		 };
	}
	else
	{
		fprintf  (stderr, "Unknown command, type \"help\" to get the list of commands\n");
	};
	
	
		
};

int main(int argc, char* argv[])
{
	if (argc == 2) 
	{
		string s = argv[1];

		if (  (s == "--version") || (s== "-v"))
		{
			fprintf (stderr,"%s", DDCVersion.c_str());	
			fprintf (stderr,"ConcordConsole, command line query processor\n");	
			return 1;
		}
	};

	Holder.m_pIndexator = 0;
	Holder.SetResultFormat("TEXT");
	Holder.m_ResultLimit=10;
	InitConcordDicts();

	if (argc == 2)
		RunCommand(string("load ") +argv[1]);

	for (;;)
	{
		printf (">");
		char Form[1000];	
		fgets(Form, 1000, stdin);
		string q = Form;

		if (bEchoQuery)
			printf ("%s", Form);

		if (Holder.m_pIndexator)
			if (Holder.m_pIndexator->m_Language == morphRussian)
				RussianConvertToDictionary(q);
		RunCommand(q);
	};


	return 0;
}


		



