

#include "../common/utilit.h"
#include "../ConcordLib/ConcCommon.h"
#include "../ConcordDmnLib/Corpora.h"
#include <syslog.h>
#include <sys/wait.h>


void PrintUsage()
{
	printf ("%s", DDCVersion.c_str() );
	printf ("Daemon for working with Dialing-DWDS Concordance\n");
	printf ("Usage: ConcordDaemon <action>  [--protocol p] [--local c] [--server s]\n");	
	printf ("Where action can be:\n");
	printf ("      start - starts daemon\n");	
	printf ("      stop - stops  daemon\n");	
	printf ("      start_cli - starts the program not as a daemon bat as a simple console program\n");	
	printf ("\"p\" can be weak|medium|heavy\n");
	printf ("\"c\" is a file for the local corpora, by default $RML/Bin/ddc_local_corpora.cfg\n");
	printf ("\"s\" is a file for the server corpora, by default $RML/Bin/ddc_server.cfg\n");
	
	
	exit(1);
};





void UnloadData()
{
	FreeConcordDicts();
	UnloadLocalCorporaAndServer();
	SocketDeinitialize();
	closelog();
};


void  termination_handler(int signum)
{
	UnloadData();
	syslog(LOG_ALERT, "Exiting from concordance ");
	concord_daemon_log	("Exiting from concordance");
	exit(1);
};



int	main(int argc, char	**argv)
{
	
	if (argc == 2) 	
	{		
		string s = argv[1];		
		if (  (s == "--version") || (s== "-v"))		
		{			
			printf ("%s", DDCVersion.c_str());				
			printf ("Daemon for working with Dialing-DWDS Concordance\n");
			return 1;		
		}	
	};
	if (argc < 2) 
		PrintUsage();

	string Error;
	if (!IsRmlRegistered(Error)) 
	{
		fprintf (stderr,"%s", Error.c_str()  );
		return 1;
	};

	ProtocolDensityEnum ProtocolDensity = pdMediumDensity;
	string CorporaFile = GetIniFilePath()+"/ddc_local_corpora.cfg";
	string ServerCorporaFile = GetIniFilePath()+"/ddc_server.cfg";
	string Action;

	for (size_t i=1; i<argc; i++)
	{
		string s = argv[i];
		if (	 (s == "-h")
				|| (s == "--help")
				|| (s == "/h")
				|| (s == "/help")
			)
			PrintUsage();
		else
			if (s == "--protocol")
			{
				if (i+1 >= argc) 
					PrintUsage();
				i++;
				s = argv[i];
				if (s == "medium")
					ProtocolDensity = pdMediumDensity;
				else
				if (s == "weak")
					ProtocolDensity = pdWeakDensity;
				else
				if (s == "heavy")
					ProtocolDensity = pdHeavyDensity;
				else
					PrintUsage();

			}
			else
				if (s == "--local")
				{
					if (i+1 >= argc) 
						PrintUsage();
					i++;
					CorporaFile = argv[i];
				}
			else
				if (s == "--server")
				{
					if (i+1 >= argc) 
						PrintUsage();
					i++;
					ServerCorporaFile = argv[i];
				}
				
				else
				{
					Action = argv[i];
				};

	};

	if (!FileExists(CorporaFile.c_str()))
	{
		fprintf (stderr, "cannot access %s\n", CorporaFile.c_str());
		exit(1);
	};

	string LockFileName = MakeFName(CorporaFile,"ddc_lck");;
	


	
	if (		(Action	!= "start")
		&&	(Action	!= "start_cli")
		&&	(Action	!= "stop")
		)
		PrintUsage();

	if (Action == "stop")
	{					
		if (access(LockFileName.c_str(), 04) !=	0)
		{
			printf("Concordance	was	not	started!\n");
			return 1;
		};
		FILE* fp = fopen (LockFileName.c_str(),	"r");
		if (!fp)
		{
			printf("Cannot open	file %s!\n", LockFileName.c_str());
			return 1;
		};
		pid_t pid;
		fscanf(fp, "%i", &pid);
		fclose (fp);

		if (kill (pid, SIGTERM)	== 0)
		{
			printf ("Concordance was stopped\n");
			remove (LockFileName.c_str());
		}
		else
			printf ("Cannot	send a SIGTERM to the process\n");
		return 1;
	};



	concord_daemon_log	("Entering ConcordDaemon");
	if (Action == "start_cli")
	{
		fprintf	(stderr, "removing %s\n",LockFileName.c_str());
		remove(LockFileName.c_str());
	};
	if (access(LockFileName.c_str(), 04) ==	0)
	{
		printf("Concordance	already	started!\n");
		return 1;
	};

	if (Action == "start")
	{		
		//	working	as a daemon
		int	fd;	int	i;
		struct rlimit flim;
		if (getppid()!=1)
		{
			signal(SIGTTOU,SIG_IGN);
			signal(SIGTTIN,SIG_IGN);
			signal(SIGTSTP,SIG_IGN);
			if(fork()!=0)
			{
				exit(0);
			};
			setsid();
		}

		getrlimit(RLIMIT_NOFILE, &flim);

		for(fd=0;fd<flim.rlim_max;fd++)
			close(fd);
		chdir("/");

		openlog("Concordance Server",	LOG_PID| LOG_CONS, LOG_DAEMON );

	}

	try{
		syslog(LOG_ALERT, "Open	a lock file	%s\n", LockFileName.c_str());
		FILE* fp = fopen (LockFileName.c_str(),	"w");
		if (!fp)
		{
			syslog(LOG_ALERT, "Cannot open file	%s!\n",	LockFileName.c_str());
			return 1;
		};
		fprintf(fp,	"%i", getpid());
		fclose (fp);

		concord_daemon_log ("SocketInitialize");
    	SocketInitialize(false);

		concord_daemon_log ("InitLemmatizers");
		if (!InitConcordDicts())
		{
			syslog(LOG_ALERT, "Cannot load Morhology\n");
			concord_daemon_log ("Cannot load Morhology");
			SocketDeinitialize();
			return 1;
		
		}

		concord_daemon_log ("LoadCorpora");
		LoadLocalCorpora(ProtocolDensity, CorporaFile);

		concord_daemon_log ("LoadServer");
		LoadDDCServer(ProtocolDensity, ServerCorporaFile);

		if (signal (SIGTERM, termination_handler) == SIG_IGN)
			signal (SIGTERM, SIG_IGN);

		if (Action == "start_cli")
			fprintf	(stderr, "\nWaiting	for	accept ... \n");

		while (1)
		{
			sleep(40);
		}
	}
	catch(...)
	{
		syslog(LOG_ALERT, "An exception	occured! ");
		concord_daemon_log ("An exception	occured!");
		UnloadData();
		SocketDeinitialize();

		return -1;
	};

	SocketDeinitialize();	

	return 0;
}





