// ConcordIndex.cpp : Defines the entry point for the console application.
//

#include <time.h>
#include "../ConcordLib/ConcCommon.h"
#include "../ConcordLib/ConcIndexator.h"


void  PrintUsageAndExit()
{
	printf ("%s", DDCVersion.c_str());	
	printf ("Usage:ConcordIndex <Concordance Project> [--only-reindex-morph] [--print-profiler-info] [--skip-initial-file-checking]\n");
	exit(1);

};



int main(int argc, char* argv[])
{

	if (argc < 2) 
		PrintUsageAndExit();
	CConcIndexatorInvoker S;
	bool bOnlyReindexMorphology = false;
	bool bPrintProfile = false;
	bool bSkipInitialFileChecking = false;
	string ProjectFile;
	for (size_t i=1; i < argc; i++)
	{
		string s = argv[i];
		if (s == "--only-reindex-morph")
		{
			printf ("--only-reindex-morph\n");
			S.m_bOnlyReindexMorphology = true;
		}
		else
			if (s == "--skip-initial-file-checking")
			{
				printf ("--skip-initial-file-checking\n");
				S.m_bSkipInitialFileChecking = true;
			}
		else
		    if (  (s == "--version") || (s== "-v"))
			{
				fprintf (stderr,"%s", DDCVersion.c_str());	
				fprintf (stderr,"ConcordIndex, DDC coprus indexator\n");	
				return 1;
			}
		else
			if (s == "--print-profiler-info")
			{
				printf ("--print-profiler-info\n");
				S.m_Profiler.m_bTimeSpanHolderEnabled = true;
			}
			else
			{
				if (!ProjectFile.empty())
					PrintUsageAndExit();
				ProjectFile = s;
			}

	};
	

	InitConcordDicts();
	
	time_t t1;
	time(&t1);

	S.m_bStdout = true;
	
	if (!S.BuildIndex(ProjectFile ))
	{
		printf ("cannot index the project!\n");
		FreeConcordDicts();
		return 1;
	};


	time_t t2;
	time(&t2);
	printf ("Seconds = %i\n", t2 - t1);
	FreeConcordDicts();
	return 0;
}

