#include "StdConc.h"
#include "../ConcordLib/ConcIndexator.h"
#include "../ConcordLib/IndexSetForLoadingStage.h"



bool	CConcIndexator::CreateAsUnion(const CConcIndexator&  _X1, const CConcIndexator&  _X2)
{

	// ============
	printf ("calculating corpus files\n");

	m_CorpusFiles = _X1.m_CorpusFiles;
	m_CorpusFiles.insert(m_CorpusFiles.end(), _X2.m_CorpusFiles.begin(),_X2.m_CorpusFiles.end());

	DeleteAllSourceFiles();
	AddSourceFilesFrom(_X1);
	AddSourceFilesFrom(_X2);
	

	if (!SaveSourceFileList(m_Path))
	{
		fprintf (stderr,"Cannot save %s\n", m_Path.c_str());
		return false;
	};

	if (!SaveCorpusFileList())
	{
		fprintf (stderr,"Cannot save corpus file list %s\n", GetFileNameForCorpusFileNames().c_str());
		return false;
	};

	// ============
	printf ("calculating corpus options\n");
	if (!_X1.HasEqualOptions (_X1))
	{
		fprintf (stderr,"These projects have different options\n");
		return false;
	};

	LoadOptionsFromString(_X1.SaveOptionsToString());
	if (!SaveOptions(m_Path))
	{
		fprintf (stderr,"Cannot options file for %s\n", m_Path.c_str());
		return false;
	};

	// =============
	assert(_X1.GetIndicesString() ==  _X2.GetIndicesString());
	printf ("uniting text and file breaks\n");
	if (!UniteBorders(_X1, _X2, _X1.GetCorpusEndTokenNo(), m_Path))
	{
		fprintf (stderr,"!!! failed!!!\n");
		return false;
	};

	// ===============
	printf ("calculating search periods\n");
	CalculateSearchPeriods(GetMaxTokenCountInOnePeriod());

	printf ("EndTokenNo of the first corpus: %i\n", _X1.GetCorpusEndTokenNo());

	// ===============
	if (_X1.GetIndicesString() !=  _X2.GetIndicesString())
		return false;

	ClearStringIndices();

	for (size_t i=0; i < _X1.m_Indices.size(); i++)
	{
		printf ("unite index \"%s\"\n", _X1.m_Indices[i]->m_Name.c_str());
		//if (_X1.m_Indices[i]->m_Name != "Thes") continue;
		CStringIndexSet* I = new CStringIndexSet (this);
		I->InitIndexSet(_X1.m_Indices[i]->m_Name, _X1.m_Indices[i]->m_ShortName, (i==0), _X1.m_Indices[i]->m_bArchiveOccurrences);
		if (!I->UnionIndexSet(*_X1.m_Indices[i], *_X2.m_Indices[i],  _X1.GetCorpusEndTokenNo(), _X2.GetCorpusEndTokenNo())) 
			return false;
		m_Indices.push_back(I);
	};

	
	printf ("Save index items buffers\n");
	if (!FinalSaveAllIndices(false))
	{
		fprintf (stderr,"Cannot save index to disk, probably no space left!");
		return false;
	}

	m_Bibl.SetPath(m_Path);
	if (!m_Bibl.UniteBibliography(_X1.m_Bibl, _X2.m_Bibl))
		return false;

	return true;
};


