#ifndef IndexSetForQueryingStage_h
#define IndexSetForQueryingStage_h



/////////////////////////////////////////////////////////////////////////////
// Flags for CIndexItem::m_IndexItemOffsetAndFlags

const DWORD TheOnlyOccurIsInEndOccurNo = 1;

/*!
	CIndexItem contains basic information about one index item. In the strict sense one index item
	is a connection between an indexed string and its occurrences. More generally the term "index item"
	is used to refer also an indexed string.
*/
class CIndexItem 
{
	// pointer to CStringIndexSet::m_StringBuffer and flags;
	DWORD				m_IndexItemOffsetAndFlags;

	// upper bound offset of occurrences in CIndexSetForQueryingStage::m_OccursFp
	DWORD				m_EndOccurOffset;

public:
	//! return m_IndexItemOffsetAndFlags for serialization
	DWORD	GetIndexItemOffsetAndFlags() const
	{
		return m_IndexItemOffsetAndFlags;
	};
	//! set m_IndexItemOffsetAndFlags for serialization
	void	SetIndexItemOffsetAndFlags(DWORD Value) 
	{
		m_IndexItemOffsetAndFlags = Value;
	};

	static size_t GetMaximalNumberOfRunningTokens()
	{
		return ~(7 << 29); // return 2^29-1
		//#ifdef USE_FSEEK32
		//	return ~(7 << 29); // return 2^29-1
		//#else
		//	return ~(3 << 30); // return 2^30-1
		//#endif
	};

	//! returns a reference of this index item to CStringIndexSet::m_StringBuffer
	DWORD	GetIndexItemOffset() const
	{
		return m_IndexItemOffsetAndFlags & ~(1<<31);
	};
	
	//! sets a reference  of this index item to CStringIndexSet::m_StringBuffer
	void	SetIndexItemOffset(DWORD Value) 
	{
		m_IndexItemOffsetAndFlags &= (1<<31);
		m_IndexItemOffsetAndFlags |= Value;
	};
	//! returns  flags of  this  index item
	DWORD	GetItemIndexFlags() const
	{
		return m_IndexItemOffsetAndFlags>>31;
	};
	//! set flags of  this  index item
	void	SetItemIndexFlags(BYTE Value) 
	{
		m_IndexItemOffsetAndFlags &= ~(1<<31);
		m_IndexItemOffsetAndFlags |= ((size_t)Value<<31);
	};
	//! return the upper bound offset of occurrences in CIndexSetForQueryingStage::m_OccursFp
	DWORD GetEndOccurOffset() const 
	{
		return m_EndOccurOffset;
	};
	//! set the upper bound offset of occurrences in CIndexSetForQueryingStage::m_OccursFp
	void SetEndOccurOffset(DWORD EndOccurOffset)  
	{
		m_EndOccurOffset = EndOccurOffset;
	};
};

inline size_t get_size_in_bytes (const CIndexItem& t)
{
	return 8;
};

inline size_t save_to_bytes(const CIndexItem& i, BYTE* buf)
{
	buf += save_to_bytes(i.GetIndexItemOffsetAndFlags(), buf);
	buf += save_to_bytes(i.GetEndOccurOffset(), buf);
	return get_size_in_bytes(i);
}

inline size_t restore_from_bytes(CIndexItem& i, const BYTE* buf)
{
	DWORD d;

	buf += restore_from_bytes(d, buf);
	i.SetIndexItemOffsetAndFlags(d);

	buf += restore_from_bytes(d, buf);
	i.SetEndOccurOffset(d);

	return get_size_in_bytes(i);
}


class CStringIndexator; 

/*!	This class is  a part of CStringIndexSet class which is used only during querying.  It contains
the important serialization primitives.
*/
class CIndexSetForQueryingStage 
{
	//! the main file of  occurrences 
	FILE*			m_OccursFp;
	
	
	//!		close m_OccursFp
	void	CloseOccursFile();
	//!		read occurrences to "OutBuffer" from position "FilePosition"
	void	ReadOccurrences (CTokenNo* OutBuffer, file_off_t FilePosition, size_t Count) const;
	//!		load all \ref perdiv_def "period divisions" to m_EndPeriodOffsets
	bool	LoadPeriodDevision();
	//!		return true, if the project path is initialized
	void	AssertHasPath() const;
	//!  get the offset of the first occurrence of index item no IndexNo in the file of occurrences(m_OccursFp)
	size_t	GetStartOccurNo(size_t IndexNo) const;
	//!  a subfunction of AddOccurs for \ref long_listdef "long lists"
	void	AddLongOccursOccurs (size_t IndexItemNo, vector<CTokenNo>& Occurs, size_t PeriodNo, COccurrBuffer& OccursBuffer ) const;
	

protected:

	//!  a function for reading occurrences for one index item
	void	AddOccurs (size_t IndexItemNo, vector<CTokenNo>& Occurs, size_t PeriodNo, COccurrBuffer& OccursBuffer, CShortOccurCache* pCacheByIndexSet, int& CacheId) const;
	//!  return the file name  for the file occurrences
	string	GetOccursFileName() const;
	//!  return the name  of file for m_Index
	string	GetOccHdrFileName() const;
	//!  return the name  of file for occurrences \ref perdiv_def "period division"
	string	GetPeriodsDevisionFileName () const;
	//!  return the name  of file for CIndexSetForLoadingStage::m_StringBuffer
	string	GetFileNameForInfos() const;
	//! return the size of the file for occurrences
	file_off_t	GetOccurrsFileSize() const;

public:
	//! the main index(from strings to the ordered list of their occurrences) 
	vector<CIndexItem>				m_Index;

	//! all corpus \ref perdiv_def "period divisions" for the long occurrence lists
	PeriodsDivisionMap			m_EndPeriodOffsets;

	//! a pointer to the collection of indices, which contains a reference to this index
	const CStringIndexator*		m_pParent;

	//! if true, then the occurrences should be archived (up to 30% for huge corpora)
	bool						m_bArchiveOccurrences;
	

	CIndexSetForQueryingStage(const CStringIndexator*		pParent);
	~CIndexSetForQueryingStage();
	//! return the name of the index (CStringIndexSet::m_Name)
	virtual string GetName() const = 0;
	//! load index set from binaries
	bool	LoadIndexSet();
	//! destroy index set and remove index files
	bool	DestroyIndexSet ();
	//! reads all occurrences of IndexItemNo (this function can allocate much memory; it should be used carefully)
	void ReadAllOccurrences (size_t IndexItemNo, vector<CTokenNo>& Occurs) const;
};




#endif
