#if !defined(__SIMPLEPARSER_H_)
#define __SIMPLEPARSER_H_

#ifndef simple_query_l
	#include "MyFlexLexer.h"
#endif

#include "QueryNode.h"
#include "list"


/*!
	CQueryParser  is a class fo the parse tree of the input query and its general properties.
	It is an of inhabitant of FlexLexer (abstract class of flex tool), so it should implement also 
	flex parser's  functionality (DDC uses YACC in thread-safe mode)
*/
class CQueryParser : protected simFlexLexer
{
	//! make this parse ready  for the new call of CQueryParser::ParseQuery
	void	CleanParser();

	//! parse a level value for a DDC filter 
	bool ParseQueryOperators (const string& OperatorName, const string& Arguments, CDDCFilterWithBounds& Filter);
	//! parse sort and filter operators from QueryStr (and delete these operators)
	bool ParseSortAndFilterOperators(string& QueryStr);


	//! an implemenation of simFlexLexer::yylex
	int yylex();
	// current node infex to set CQueryTokenNode::m_NodeIndex
	int									m_CurrentNodeIndex;

public:
	//! the break collection name which should be used while querying
	string								m_HitTypeStr;
	//! the index of text area where DDC should perform the input query
	int									m_TextAreaNo;
	//! filters and sort operators which should be applied to the resulted hit set
	vector<CDDCFilterWithBounds>		m_Filters;
	//! how many hits of the left and right context should be output
	size_t								m_ContextSentencesCount;
	//!  the top of the parse tree
	CQueryNode*							m_pQueryTree;	
	//!  a reference to the holder, for which this query is parsed
	const CConcHolder*					m_pHolder;
	//! a special slot for YACC (which contains all string leaves of the parse tree)
	list<string>						m_Labels;
	//! a special slot for YACC (which contains the current queue  of nodes inside a sequence operator )
	vector<const CQueryNode*>			m_CurrSequenceObj;	
	//! a special slot for YACC (which contains the current queue  of text distances between nodes inside a sequence operator )
	vector<string>						m_CurrDistances;
	// if true, DDC shows file names, instead of bibliographical information for this query (CConcIndexator::m_bOutputBibliographyOfHits is default value for outputting bibliography
	bool								m_bEnableBibliographyForThisQuery;
	// if true, DDC initializes CHit::m_DebugRank
	bool								m_bDebugRank;

	CQueryParser(const CConcHolder*		pHolder);
	virtual ~CQueryParser();

	//! delete parse tree ( CQueryParser::m_pQueryTree )
	void	DeleteTree();

	//! an instance of yylex member from the main flex class 
	int yylex (void* valp);
	//! parse "query_src" and build a parse tree for it 
	bool	ParseQuery(const char* query_src);
	//! evaluate parse tree bottom-up
	bool	Evaluate();
	// return current node index to set CQueryTokenNode::m_NodeIndex
	int		GetNewNodeIndex();
	// return m_CurrentNodeIndex
	size_t	GetNodeIndicesCount() const;
};

#endif
