// ConcordSimple.cpp : Defines the entry point for the 



#include <time.h>

#include "../ConcordLib/ConcHolder.h"
extern size_t AllBytesRead;;

#ifdef DETECT_MEMORY_LEAK
	#define _CRTDBG_MAP_ALLOC
	#include <stdlib.h>
	#include <crtdbg.h>
#endif


inline bool IsTableFile (const string& FileName)
{
	int len = FileName.length();
	string R = FileName;
	EngMakeLower(R);

	return (   (len > 5)
			&& (   !strcmp (FileName.c_str()+len-5, "table")
			   )
		   );
}


 

void PrintUsageAndExit()
{
	fprintf (stderr,"%s", DDCVersion.c_str());	
	fprintf (stderr, "Usage(1):ConcordSimple <Concordance Project> <query in Windows CODEPAGE><out-file>[-Limit n][-ProfileRun n] [-ResultFormat TXT|HTML|TABLE] [-PrintProfile] [-OnlyGetHitsCount] [-From HitStart] [-NoMorphology]\n");
	fprintf (stderr, "Where \"-Limit\" is maximal count of occurrences to find \n");
	fprintf (stderr, "and \"-From\" is the number of occurence to start from \n");
	fprintf (stderr, "Example(1): ConcordSimple test.con \"thank && God\" out.txt -Limit 10\n");
	exit(1);

};

int main(int argc, char* argv[])
{

	{
		StringVector Args;
		int ResultLimit  = -1;
		bool bPrintProfile = false;
		bool bOnlyGetHitsCount = false;
		bool bInitConcordDicts = true;
		int CountOfCycles = 1;
		string _Query;
		string Corpus;
		string OutFileName;
                string ResultFormat = "GUESS"; 
		int ContextSize = -1;
                DWORD StartFrom = 0;

		for (size_t i=1; i<argc; i++)
		{
			string s  = argv[i];
			if (s == "-Limit")
			{
				if (i+1 >= argc)
					PrintUsageAndExit();

				ResultLimit = atoi(argv[i+1]);
				i++;
			}
                        else
			if (s == "-From")
			{
				if (i+1 >= argc)
					PrintUsageAndExit();

				StartFrom = atoi(argv[i+1]);
				i++;
			}
                        else
			if (s == "-ResultFormat")
			{
				if (i+1 >= argc)
					PrintUsageAndExit();

				ResultFormat = argv[i+1];
				i++;
			}
			else
			if (s == "-PrintProfile")
			{
				bPrintProfile = true;
				fprintf  (stderr, "print profililng afterwards\n");
			}
			else
			if (s == "-NoMorphology")
			{
				bInitConcordDicts = false;
				fprintf  (stderr, "no call to InitConcordDicts\n");
			}
			else
			if (s == "-OnlyGetHitsCount")
			{
				bOnlyGetHitsCount = true;
				fprintf  (stderr, "OnlyGetHitsCount\n");
			}
			else
			if (s == "-ProfileRun")
			{
				if (i+1 >= argc)
					PrintUsageAndExit();
				else
				{
					CountOfCycles = atoi(argv[i+1]);
					fprintf (stderr,"Count of profile cycles = %i\n", CountOfCycles);
					i++;
				};

			}
			else
		    if (  (s == "--version") || (s== "-v"))
			{
				fprintf (stderr,"%s", DDCVersion.c_str());	
				fprintf (stderr,"ConcordSimple, command line query processor\n");	
				return 1;
			}
			else
				Args.push_back(argv[i]);

		};

		if (Args.size() != 3)
			PrintUsageAndExit();
		Corpus = Args[0];
		_Query = Args[1];
		OutFileName =  Args[2];


		{
		
			CConcHolder R;

			R.m_pIndexator = new CConcIndexator;

			if (bPrintProfile)
				R.m_Profiler.m_bTimeSpanHolderEnabled = true;

			if (!R.m_pIndexator->LoadProject(Corpus) )
			{
				fprintf (stderr, "cannot load project %s\n", Corpus.c_str());
				return -1;
			};

			if (bInitConcordDicts)
				InitConcordDicts();
			
			FILE* OutFile = 0;
			
			fprintf  (stderr, "Open output file %s\n", OutFileName.c_str());
			remove(OutFileName.c_str());
			OutFile = fopen (OutFileName.c_str(), "w");
			if (!OutFile)
			{
				fprintf (stderr, "cannot open output file  %s\n", OutFileName.c_str());
				return -1;
			};

			R.m_ResultLimit = 10;

			if (ResultLimit != -1)
				R.m_ResultLimit = ResultLimit;

			fprintf  (stderr, "Finding at least %i occurrences\n", R.m_ResultLimit);

                        if (ResultFormat=="GUESS")
                        {
    		            if (IsHtmlFile(OutFileName.c_str()))
					ResultFormat = "HTML";
			    else
				if (IsTableFile(OutFileName.c_str()))
					ResultFormat = "TABLE";
				else
					ResultFormat = "TEXT";
                        };

                        R.SetResultFormat(ResultFormat);

			R.m_QueryResultStr = "";
			
			vector<string>	queries;
			if (_Query != "query.txt")
				queries.push_back(_Query);
			else
			{
		 		FILE *fp = fopen(_Query.c_str(), "r");
				if (!fp)
				{
					fprintf (stderr, "cannot open input file  %s\n", _Query.c_str());
					return 1;
				}
				else
				{
					char s[1000];
                    while (fgets(s,1000,fp))
					{
                        string q = s;
						Trim(q);
						if (!q.empty())
							queries.push_back(q);
					}
					fclose (fp);
				};
			};
			
			

			DWORD  EndHitNo = StartFrom;		
			DWORD  HitsCount = 0;
			

			clock_t     AllStartTime = clock();
			
			

			for (int ProfileCycleNo=0; ProfileCycleNo < CountOfCycles; ProfileCycleNo++)
				for (int QueryNo=0; QueryNo < queries.size(); QueryNo++)
				{
			
					string Query = queries[QueryNo];
					printf ("Query =  %s\n", Query.c_str());
					EndHitNo = StartFrom;
					if (bOnlyGetHitsCount)
					{
						clock_t     StartTime = clock();
						DDCErrorEnum Error =   R.GetHits(Query, EndHitNo);
                        clock_t     EndTime = clock();

						long      TimeSpan = EndTime - StartTime;
						
						printf ("ticks %i\n", TimeSpan ); 
						
						if (Error != errUnknown)
						{
							fprintf (stderr, "Error! %s \n", GetDDCErrorString(Error).c_str());
							return -1;
						}
						else
						{
							printf ("Number of found docs : %i\n", R.m_AllHitsCount);
						}
					}
					else
					{
						DDCErrorEnum Error =   R.SimpleQuery(Query, EndHitNo, HitsCount);
						if (Error != errUnknown)
						{
							fprintf (stderr, "Error! %s \n", GetDDCErrorString(Error).c_str());
							return -1;
						};

					}
					R.ClearQueryCache();
				};
			
			
			clock_t     AllEndTime = clock();
			printf ("Seconds = %03f\n", (double)(AllEndTime - AllStartTime)/(double)CLOCKS_PER_SEC);
			fprintf (stderr, "HitsCount = %i\n", HitsCount);
			fprintf (OutFile, "%s", R.m_QueryResultStr.c_str());
			fclose(OutFile);

			fprintf (stderr, "All bytes read while querying = %i\n", AllBytesRead);
			if (bPrintProfile)
				fprintf (stderr, "===== Profiler  ====\n %s\n",R.m_Profiler.GetStrRepresentation().c_str());

			delete R.m_pIndexator;

		}
		FreeConcordDicts();
	}



	return 0;
}





