// ==========  This file is under  LGPL, the GNU Lesser General Public Licence
// ==========  Dialing Posmorphological Module (www.aot.ru)
// ==========  Copyright by Dmitry Pankratov, Alexey Sokirko (1999-2002)


#include "MAPostMain.h"
#include "../common/PlmLine.h"



int GetMult(int num, HyphenVec & variants)
{
	int r = 1;
		for( int i = num ; i < variants.size() ; i++ )
		   r *= variants.m_Items[i].size();
	return r;
}

void GetVariants(HyphenVec& lines_to_concat, VariantsVec& variants)
{
	int variants_num = 1;
	
	int i = 0;
	for(; i < lines_to_concat.size() ; i++ )				
		variants_num *= lines_to_concat.m_Items[i].size();

	int mult;
	for( i = 1 ; i <= variants_num ; i++ )
	{
		HomonymsVec variant;
		int num = i;
		 for ( int j = 0 ; j < lines_to_concat.size(); j++ )
	     {
			mult = GetMult(j+1, lines_to_concat);
			int index = num / mult;			
			if ( num % mult == 0 ) 
				index--;         ;
			num -= mult * index;
			assert(index < lines_to_concat.m_Items[j].size() );
			variant.Add(lines_to_concat.m_Items[j].m_Items[index]);
	     }
		variants.Add(variant);
	}
}


bool CMAPost::TryToConCatLines(const HomonymsVec& variant, CPlmLine& new_line) const
{
	bool b_adj = true, b_noun = true, b_adv = true, b_numeral = true;
	int i = 0;
	for( ; i < variant.size() ; i++ )
	{
		BYTE pos = variant.m_Items[i]->m_Pos;
		b_adj =	( (pos == ADJ_FULL) || (pos == ADJ_SHORT) ) && b_adj; // -
		b_noun = (pos == NOUN) && b_noun; // -
		b_adv = (pos == ADV) && b_adv; // "-"
		b_numeral = (pos == NUMERAL) && b_numeral; // "- "
		if(!b_adj && !b_noun && !b_adv && !b_numeral)
			return false;
	}

	string NewGramCodes;
	string GramCodesIntersection = variant.m_Items[0]->GetGramCodes();
	for(i = 1 ; i < variant.size() ; i++ )
	{
		const string& CurrGramCodes = variant.m_Items[i]->GetGramCodes();
		if( b_adj )
		{
			QWORD g;
			m_pRusGramTab->GetGrammems(CurrGramCodes.c_str(), g);
			if(    g & (1 << rShortForm) )
				continue;
			else
				if( NewGramCodes.length() == 0 )
				{
					GramCodesIntersection = CurrGramCodes;					
				}
		}
		
   		 for (size_t l=0; l<GramCodesIntersection.length(); l+=2)
		   for (size_t m=0; m < CurrGramCodes.length(); m+=2)
		   {
			   string Gram1 = GramCodesIntersection.substr(l, 2);
			   string Gram2 = CurrGramCodes.substr(m, 2);

			   if(    m_pRusGramTab->GleicheCaseNumber(Gram1.c_str(),Gram2.c_str()) 
				   || b_adv
				   || (	  b_numeral
				        && m_pRusGramTab->GleicheCase(Gram1.c_str(),Gram2.c_str()) 
					  )
				 )
			   {			
					 int j = 0;
				   for(  ; j < NewGramCodes.length() ; j+=2)
					   if( NewGramCodes.substr(j, 2) == Gram2.c_str() )
						   break;
				   if( j >= NewGramCodes.length() )
					   NewGramCodes+=Gram2.c_str();

				   for( j = 0 ; j < NewGramCodes.length() ; j+=2)
					   if( NewGramCodes.substr(j, 2) == Gram1.c_str() )
						   break;
				   if( j >= NewGramCodes.length())
					   NewGramCodes+= Gram1;
			   }
			 
		   }
		GramCodesIntersection = NewGramCodes;
	}

	if( NewGramCodes.length() == 0)
			return false;



	/*
	      .     ,  
	       ,    
	  "-"   "	"
	*/
	new_line = *variant.m_Items[0];
	new_line.SetGramCodes("",m_pRusGramTab);
	new_line.SetWord("");
	new_line.m_Lemma = "";

	new_line.m_GraphDescr = variant.m_Items[0]->m_GraphDescr;
	new_line.m_FilePosition = variant.m_Items[0]->m_FilePosition;
	for(i = 0 ; i < variant.size() ; i++ )
	{
		new_line.SetWord(new_line.GetWord() +  variant.m_Items[i]->GetWord() );
		
		string GramCodes = variant.m_Items[i]->GetGramCodes();
		QWORD g;
		m_pRusGramTab->GetGrammems(GramCodes.c_str(), g);
		if ( g & (1 << rShortForm) )
			new_line.m_Lemma +=  variant.m_Items[i]->GetUpperWord();
		else				
			new_line.m_Lemma +=  variant.m_Items[i]->m_Lemma;
	
		//  
		if( i < variant.size() - 1)
		{
			new_line.m_Lemma += "-";
			new_line.SetWord(new_line.GetWord() + "-");
		}
		if  (variant.m_Items[i]->m_bSent2)
			new_line.m_bSent2 = true;
		

	}
	new_line.m_bHomonym  = false;
	new_line.m_bHyphenWord = true;
	new_line.SetMorphUnknown();
	new_line.SetGramCodes(NewGramCodes,m_pRusGramTab);
	
	return true;
}



 /*
    :
 -                       9 0 9 RLE aa HYP CS? ?? -1
                              4 0 4 RLE aa HP1-n   -1
  -                               1 4 1 PUN HYP
                              4 5 4 RLE aa HP2 CS? -n   -1

 */


void CMAPost::Defslo() 
{
	assert(m_Lines.size() > 0);
	VariantsVec* pVariants = new VariantsVec; 
	assert (pVariants);

	CLineIter it=m_Lines.begin();

	for (; it !=  m_Lines.end(); it++)
	{
		
		//          
		
		if(    (it->GetGramCodes().find("??") != string::npos) 
			&& it->m_bHyphenWord
		  )
		{
			CLineIter next_it = it;
			HyphenVec lines_to_concat; 
			pVariants->Clear();
			

			
			//   
			
			next_it++;
			if( next_it == m_Lines.end()  )
				break;

			if( !next_it->m_bHomonym )
				continue;


			HomonymsVec homonyms;
			bool bError = false;


			do
			{
				const string& GraDescr = next_it->m_GraphDescr;
				if( next_it->m_TokenType == RLE )
				{
					homonyms.Add(next_it);
				}
				else 
				{
					if( GraDescr.find("HYP") != string::npos )
					{
						//         -  
						if( !homonyms.size() )
						{
							bError = true;
							break;
						}						
						lines_to_concat.Add(homonyms);
						homonyms.Clear();
					}		
					else
					{
						//   -     - 
						bError = true;
						break;
					}
				}	

				next_it++;
				if( next_it == m_Lines.end() )
				{
					//       - 
					if( GraDescr.find("HYP") != string::npos )
						bError = true;
					break;
				}

			}while(next_it->m_bHomonym && (next_it != m_Lines.end()) );

			if( !bError && homonyms.size() )
			{
				lines_to_concat.Add(homonyms);				

				GetVariants(lines_to_concat, *pVariants);

				int count_of_variants = 0;
				for( int i = 0 ; i < pVariants->size() ; i++)
				{
					CPlmLine new_line;
					//      a
					if( count_of_variants > 5 )
						break;

					if( TryToConCatLines((*pVariants).m_Items[i], new_line) )
					{
						if( count_of_variants > 0)
							new_line.m_bHomonym = true;
						m_Lines.insert(it, new_line);
						count_of_variants++;
					}						
				}

				

				
				//   
				
				if ( count_of_variants > 0 )
				{
					while (it != next_it)
					{
						//  bRemoveSpaceAfterDeletedWord     false,
						//  next_it     ,     
						//    
						it = Remove(it, false);
						//s = it->GetStr();
						if (it == m_Lines.end()) break;
					};
					it--;
				};
			}
		}
		
	};

	
	delete pVariants;
}



