#include "stdafx.h"
#include "AncodePattern.h"
#include "SyntaxInit.h"


CAncodePattern::CAncodePattern()
{
	m_iGrammems = 0;
	m_iPoses = 0;
	m_iTagID = 0;
	m_TypeGrammems = 0;
	m_LemSign = 0;
};

void CAncodePattern::CopyAncodePattern(const CAncodePattern& X)
{
	m_iGrammems = X.m_iGrammems;
	m_iPoses = X.m_iPoses;
	m_GramCodes = X.m_GramCodes;
	m_iTagID = X.m_iTagID;
	m_SimplePrepNos = X.m_SimplePrepNos;
	m_LemSign = X.m_LemSign;
	m_CommonGramCode = X.m_CommonGramCode;
	m_TypeGrammems = X.m_TypeGrammems;
};


bool CAncodePattern::HasGrammem(BYTE gram) const 
{ 
	return		((m_iGrammems    & _QM(gram)) > 0)
			||	((m_TypeGrammems & _QM(gram)) > 0);
}

bool CAncodePattern::HasPos(BYTE pos) const
{ 
	return (m_iPoses & (1 << pos)) > 0; 
};


string CAncodePattern::GetGrammemsByAncodes(const CAgramtab* Agramtab) const
{
	string Result;
	for (int i = 0; i < m_GramCodes.length(); i += 2)
	{
		QWORD g;
		if (!Agramtab->GetGrammems(m_GramCodes.c_str()+i, g))
		{
				assert (false);
		};
		Result += Agramtab->GrammemsToStr(g);
		Result += "; ";

	};
	return Result;
};

bool CAncodePattern::ModifyGrammems(const CSyntaxOpt* Opt, QWORD Grammems , size_t Poses)
{
	const CAgramtab& piGramTab = * (Opt->GetGramTab());
	string strOldGramcodes = m_GramCodes;	
	QWORD  savegrammems = m_iGrammems;	
	size_t saveposes = m_iPoses;
	size_t savetagid = m_iTagID;
	m_iGrammems = 0;
	m_iPoses = 0;
	m_GramCodes = "";
	m_iTagID = UnknownPartOfSpeech;

	for (size_t j=0; j < strOldGramcodes.length(); j+=2)
	{
			QWORD CurrGrammems = 0;		
			bool b = piGramTab.GetGrammems(strOldGramcodes.c_str() + j, CurrGrammems);
			assert (b);
			if (!b)
			{
				Opt->OutputErrorString(Format("Cannot get grammems by gramcode %s ",strOldGramcodes.substr(j,2).c_str()));
				m_iGrammems = 0;
				break;
			};
			BYTE CurrPOS = piGramTab.GetPartOfSpeech(strOldGramcodes.c_str() + j);
			
			/*
				there are tow possibilities:
					1. "Grammems" contains only one or two grammems, and all gramcodes of this 
						pattern should contain this "Grammems"
					2. "Grammems" is a union of all possible grammems and all gramcodes should be inside
					   this union.

			*/
			if (Poses & (1<<CurrPOS))
				if(    ((Grammems & CurrGrammems) == CurrGrammems) 
					|| ((Grammems & CurrGrammems) == Grammems)
				)
				{
					m_iGrammems |= CurrGrammems;
					m_GramCodes += strOldGramcodes.substr(j,2);
					BYTE pos = piGramTab.GetTagId(strOldGramcodes.c_str() + j);
					m_iPoses |= (1 << pos);
					if (m_iTagID == UnknownPartOfSpeech)
						m_iTagID = pos;

				}
			
	}		
	if ( (m_iGrammems == 0) && (savegrammems != 0))
	{
		m_GramCodes = strOldGramcodes;	
		m_iGrammems = savegrammems;	
		m_iPoses = saveposes;
		m_iTagID = savetagid;
		return false;
	}
	//assert (!m_GramCodes.empty());
	return true;
};


bool CAncodePattern::InitAncodePattern(const CSyntaxOpt* Opt)
{
	const CAgramtab& piGramTab = * (Opt->GetGramTab());

	m_iGrammems = 0;
	m_iPoses = 0;
	m_iTagID = UnknownPartOfSpeech;

	if	(		!m_GramCodes.empty()
			&& 	(m_GramCodes[0] != '?') 
		)
	{
		for (size_t j=0; j < m_GramCodes.length(); j+=2)
		{
				QWORD CurrGrammems = 0;		
				bool b = piGramTab.GetGrammems(m_GramCodes.c_str() + j, CurrGrammems);
				assert (b);
				if (!b)
				{
					Opt->OutputErrorString(Format("Cannot get grammems by gramcode %s ",m_GramCodes.substr(j,2).c_str()));
				};
				m_iGrammems |= CurrGrammems;
				BYTE pos = piGramTab.GetTagId(m_GramCodes.c_str() + j);
				m_iPoses |= (1 << pos);
				if (m_iTagID == UnknownPartOfSpeech)
					m_iTagID = pos;
				
		}		
	}
	m_TypeGrammems = 0;
	if	(		(m_CommonGramCode.length() == 2)
			&&	(m_CommonGramCode != "??")
		)
	{
		bool b = piGramTab.GetGrammems(m_CommonGramCode.c_str(), m_TypeGrammems);
		assert (b);
		if (!b)
		{
			Opt->OutputErrorString(Format("Cannot get grammems by type gramcode %s ",m_CommonGramCode.c_str()));
		};
	};


	return true;
};
