#ifndef ancode_pattern_h
#define ancode_pattern_h

class CAgramtab;
class CSyntaxOpt;

struct CAncodePattern 
{
	QWORD			m_TypeGrammems;
	QWORD			m_iGrammems;
	char			m_LemSign;
	string			m_CommonGramCode;
	string			m_GramCodes;
	size_t			m_iPoses;
			
	size_t			m_iTagID;	// the first part of speech

	// all single preposition interpretations
	vector<int>		m_SimplePrepNos;

	CAncodePattern();
	void	CopyAncodePattern(const CAncodePattern& X);
	bool	HasGrammem(BYTE gram) const;
	bool	HasPos(BYTE pos) const;
	string	GetGrammemsByAncodes(const CAgramtab* Agramtab) const;
	bool	ModifyGrammems(const CSyntaxOpt* Opt, QWORD Grammems, size_t Poses=0xffffffff);
	bool	InitAncodePattern(const CSyntaxOpt* Opt);


};


#endif
