// ==========  This file is under  LGPL, the GNU Lesser General Public Licence
// ==========  Dialing Syntax Analysis (www.aot.ru)
// ==========  Copyright by Dmitry Pankratov, Igor Nozhov, Alexey Sokirko


#include "stdafx.h"
#include "SynPlmLine.h"




CSynPlmLine::CSynPlmLine()
{
	reset();
}



void CSynPlmLine :: reset ()
{
	m_ClauseType = UnknownSyntaxElement;
	m_word = 0;
	m_word_upper = 0;
    m_lemma = m_gramcodes = 0;
	m_pOborot = NULL;
	m_Grammems = 0;
    poses = 0;
	m_Flags = 0;
	m_pSimplePrepNos = 0;
	m_FoundPrepDependCases = 0;
	m_UnitType = EWord;
	m_DisruptOborotId = UnknownSyntaxElement;
	tag_id = UnknownPartOfSpeech;
	m_TypeGrammems = 0;
	m_type_gram_code = 0;
}


void CSynPlmLine::SetFlag (PlmLineFlagEnum PlmLineFlag, bool bStatus)
{
	if (bStatus)
		m_Flags |= _QM(PlmLineFlag);
	else
		m_Flags &=  ~(_QM(PlmLineFlag));
};





QWORD CSynPlmLine :: GetGrammems () const
{
	return m_Grammems;
};

void CSynPlmLine :: SetGrammems (QWORD value) 
{
	m_Grammems = value;
};


void CSynPlmLine :: SetMorphByAncodePattern (const CAncodePattern & P) 
{
	m_Grammems = P.m_iGrammems;
	m_TypeGrammems = P.m_TypeGrammems;
	poses = P.m_iPoses;
	tag_id = P.m_iTagID;
	m_gramcodes = P.m_GramCodes.c_str();
	m_type_gram_code = P.m_CommonGramCode.c_str();
};


size_t CSynPlmLine :: GetPoses () const
{
	return poses;
};


bool	CSynPlmLine :: is_single_punct (BYTE c ) const
{
	return		m_word
			&&	((BYTE)m_word[0] == c) 
			&&	(m_word[1] == 0);
	
}


bool CSynPlmLine :: has_lemma() const 
{
	return (m_lemma != 0) &&  (m_lemma[0] != 0);
};

bool CSynPlmLine :: is_lemma(const char* lemma) const 
{
	if (!has_lemma()) return false;
	if (lemma == 0) return false;
	return !strcmp(m_lemma,lemma);

};

bool CSynPlmLine :: is_word_upper(const char* word_upper) const 
{
	if (m_word_upper == 0) return false;
	if (word_upper == 0) return false;
	return !strcmp(m_word_upper,word_upper);

};

bool CSynPlmLine :: has_grammem (BYTE g)  const
{
	return		(	(m_Grammems & _QM(g) )!= 0)
			||	(	(m_TypeGrammems & _QM(g) )!= 0);
};

bool CSynPlmLine :: is_morph_noun () const
{
	return  HasFlag(fl_morph_noun);
};
bool CSynPlmLine :: is_syn_noun() const
{
	return   HasFlag(fl_syn_noun);
};

bool CSynPlmLine :: HasFlag (PlmLineFlagEnum Flag)  const
{ 
	return (m_Flags & _QM(Flag)) > 0;
}

void CSynPlmLine :: SetPoses (size_t value)
{ 
	poses = value;
}

