// ==========  This file is under  LGPL, the GNU Lesser General Public Licence
// ==========  Dialing Syntax Analysis (www.aot.ru)
// ==========  Copyright by Dmitry Pankratov, Igor Nozhov, Alexey Sokirko

#ifndef plmline_h
 #define plmline_h

#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "Period.h"
#include "oborot.h"
#include "../common/utilit.h"
#include "AncodePattern.h"






const int MaxDesLength = 100;
const int MaxGraWordLen = 100;
const int MaxLemmaLen = 100;
const int MaxGramCodesLen = 100;


typedef vector<int> CIntVector;

enum  PlmLineFlagEnum {
	fl_file_name1=1, 
	fl_file_name2=2,
	fl_keyb1=3,
	fl_keyb2=4,
	fl_digits=5,
	fl_punct=6,
	fl_russian_odin=7, // for Russian
	fl_oborot1=8,
	fl_oborot2=9,
	fl_in_oborot=10,
	fl_le=11, // for Russian
	fl_ile=12,
	fl_ranknoun=13,
	fl_digit=14,
	fl_ambiguous  =15, 
	fl_unk_gramcodes=16,
	fl_comma=17,
	fl_dt_fork=18,
	fl_month=19,
	fl_small_number=20, // for Russian
	fl_adv_adj=21, // for Russian
	fl_can_syn_depend_on_adj=22, // for Russian     
	fl_can_syn_depend_on_adv=23, // for Russian     
	fl_dg_ch=24,
	fl_standard_param_abbr=25,
	fl_fullstop=26,
	fl_dash=27,
	fl_morph_noun=28,
	fl_syn_noun=29,
	fl_relative_clause=30,
	fl_bracket=31,
	fl_article_for_weak_declination=32, // for German
	fl_article_for_mixed_declination=33, // for German
	fl_has_space_before=34,
	fl_fam1 = 35,
	fl_fam2 = 36,
	fl_first_char_is_upper = 37,
	fl_is_russian = 38,
	fl_adjective_as_noun = 39,
	fl_can_subdue_infinitive = 40,
	fl_morph_predicted = 41,
	fl_register_BB = 42,
	fl_can_subdue_instr = 43,
	fl_noun_has_adj_declination = 44

};




class CSynPlmLine
{
	QWORD					m_Flags;

	// a union of all possible grammems, which is built by m_gramcodes
	QWORD					m_Grammems; 

	// type grammems
	QWORD					m_TypeGrammems; 

	// all possible part of speeches
	size_t					poses; 

public:	
	

	// the first part of speech in union poses
	short					tag_id; 


	// a pointer to  oborot entry if this word starts an oborot
	const COborotForSyntax* m_pOborot;

	// an ID of oborot for disruptive conjunction which should be inited by CFormatCaller::create_disrupt_conj_group
	WORD					m_DisruptOborotId;

	//    ,   ,     
	QWORD					m_FoundPrepDependCases;

	//       (,+, +),  0,   	 CSynPlmLine  
	const vector<int>*		m_pSimplePrepNos;


	/*
	 m_word  m_word_upper    0,  
	 CSynPlmLine  
	*/
	const char*				m_word;
	const char*				m_word_upper;
	
	/*
	 m_lemma    0,  
	 CSynPlmLine    m_word   
	*/
	const char*				m_lemma;
	const char*				m_gramcodes;
	const char*				m_type_gram_code;
	BYTE					m_CoordConjNo;
	
	EUnitType				m_UnitType;
	EClauseType				m_ClauseType;
	CPeriod					m_Clause;

	CSynPlmLine(); 
	void reset ();


	bool	is_single_punct (BYTE c ) const;
	bool	has_lemma() const;
	bool	is_lemma(const char* lemma) const;
	bool	is_word_upper(const char* word_upper) const;
	bool	has_grammem (BYTE g)  const;
	bool	is_morph_noun () const;
	bool	is_syn_noun() const;
	bool	HasFlag (PlmLineFlagEnum Flag)  const;
	QWORD	GetGrammems () const;
	size_t	GetPoses () const;

    void	SetFlag (PlmLineFlagEnum PlmLineFlag, bool bStatus);
	void	SetGrammems (QWORD value);
	void	SetPoses (size_t value);
	void	SetMorphByAncodePattern (const CAncodePattern & P);

};

typedef vector<CSynPlmLine> CPlmVector;
#endif
