// ==========  This file is under  LGPL, the GNU Lesser General Public Licence
// ==========  Dialing Syntax Analysis (www.aot.ru)
// ==========  Copyright by Dmitry Pankratov, Igor Nozhov, Alexey Sokirko

#include "StdSynan.h"
#include "RusFormatCaller.h"

// :
//     
//        

bool CRusFormatCaller::format_for_comp_adv (CGroup& G)
{
	G.m_iLastWord  = G.m_iFirstWord;

	if ( G.m_iFirstWord >= sent.size() - 1)  return false;

    if ( !has_item( GetOpt()->m_pCompAdvList, W1.m_word) ) return false;

	int I = get_minimal_group(G.m_iFirstWord+1);

	if   (I == -1)
       if (    W2.has_grammem(rComparative)
		   && (is_morph_adj(W2) || (W2.tag_id == ADV)))
			{   G.m_iLastWord++;

	            G.m_MainGroup = G.m_iLastWord;
				create_syn_rel(G, G.m_iFirstWord, G.m_iLastWord, COMP_ADV);				
			    G.m_Cause = "     .  .";}
	   else;
    else
      if  (    (GetGroups()[I].m_GroupType == SIMILAR_ADJS)
		    && sent[GetGroups()[I].m_MainGroup.m_iFirstWord].has_grammem(rComparative))
	  {   
		  G.m_iLastWord = GetGroups()[I].m_iLastWord;
	      G.m_MainGroup = GetGroups()[I].m_MainGroup.m_iFirstWord;
		  create_syn_rel(G, G.m_iFirstWord,get_main_word_in_group(GetGroups()[I]), COMP_ADV);
		  G.m_Cause = "     .  .";
	  }



   G.m_GroupType = COMP_ADV;
   return G.m_iFirstWord != G.m_iLastWord;
}

bool IsUZH_Particle (const CSynPlmLine& W)
{
	return W.is_lemma("") && (W.GetPoses() & (1<<PARTICLE) );
};


// :
//      
//	     ()
//         ()
//        ()
//       ()

bool CRusFormatCaller::format_for_adv_adj(CGroup& G)
{
	try 
	{
		int i = get_main_word (G.m_iFirstWord);
		if (IsUZH_Particle(Wi))
		{
			i = get_next_main_word (i);
			if (i == sent.size()) return false;
		}
		if (!Wi.HasFlag(fl_adv_adj)) return false;
		if (!Wi.HasFlag(fl_can_syn_depend_on_adj) ) return false;

		int j = get_next_main_word (i);
		if (j == sent.size()) return false;

		//   ,   
		if (GetGramTab()->IsParticle(Wj.m_lemma, Wj.GetPoses()))
			j = get_next_main_word (j);
		if (j == sent.size()) return false;

		if( Wj.has_grammem(rComparative) )	 return false;

		if ( !is_morph_adj(Wj) && !is_morph_participle(Wj)  )
			return false;


		G.m_Cause = "  ( \"\")     ";
		G.m_GroupType = ADV_ADJ;

		G.m_MainGroup = get_maximal_group(j);
		G.m_iLastWord = G.m_MainGroup.m_iLastWord;
		for (size_t k=get_main_word(G.m_iFirstWord); k != j; k  = get_next_main_word(k))
			create_syn_rel(G, j, k, ADV_ADJ);
		return true;
	}
	catch (...)
	{
		throw CExpc ("CRusFormatCaller::format_for_adv_adj exception");
	};
};

//
// 
// 
//  
//  
bool CRusFormatCaller::format_for_adv_number_adverb (CGroup& G)
{
	int i = get_main_word (G.m_iFirstWord);

	if (IsUZH_Particle(Wi))
		i = get_next_main_word (i);

	if (i == sent.size()) return false;

	if( !is_morph_adv(Wi) )
		return false;

	if( !Wi.HasFlag(fl_can_syn_depend_on_adv) )
		return false;

	int j = get_next_main_word (i);
	if (j == sent.size()) return false;
	//   ,   
	if (GetGramTab()->IsParticle(Wj.m_lemma, Wj.GetPoses()))
		j = get_next_main_word (j);
	if (j == sent.size()) return false;

	if (!has_item (GetOpt()->m_pNumberAdverbsList, Wj.m_lemma)) 
		return false;

	G.m_GroupType = ADV_NUM_ADV;

	G.m_MainGroup = get_maximal_group(j);
	G.m_iLastWord = G.m_MainGroup.m_iLastWord;
	for (size_t k=get_main_word(G.m_iFirstWord); k != j; k  = get_next_main_word(k))
		create_syn_rel(G, j, k, ADV_NUM_ADV);

	return true;
}


//:
//	 ,  , "  ", "   "
//       _  " "
bool CRusFormatCaller::format_for_adv_adv(CGroup& G)
{
	int i = get_main_word (G.m_iFirstWord);

	if ( IsUZH_Particle(Wi) )
		i = get_next_main_word (i);

	if (i == sent.size()) return false;
		
	if( !is_morph_adv(Wi) )
		return false;

	if( Wi.is_word_upper("") )
		return false;

	if( !Wi.HasFlag(fl_can_syn_depend_on_adv) )
		return false;
	int j = get_next_main_word (i);
	if (j == sent.size()) return false;
	//   ,   
	if (GetGramTab()->IsParticle(Wj.m_lemma, Wj.GetPoses()))
		j = get_next_main_word (j);
	if (j == sent.size()) return false;

	if( !is_morph_adv(Wj) )
		return false;

	if (Wj.is_lemma(""))
		return false;

	G.m_GroupType = ADV_ADV;	
	G.m_MainGroup = get_maximal_group(j);
	G.m_iLastWord = G.m_MainGroup.m_iLastWord;
	for (size_t k=get_main_word(G.m_iFirstWord); k != j; k  = get_next_main_word(k))
		create_syn_rel(G, j, k, ADV_ADV);
	return true;
}

//    : " ";
bool CRusFormatCaller::format_for_adv_predik(CGroup& G)
{
	int i = get_main_word (G.m_iFirstWord);

	if ( IsUZH_Particle(Wi) )
		i = get_next_main_word (i);
	
	if (i == sent.size()) return false;

	if( !is_morph_adv(Wi) )
		return false;

	int j = get_next_main_word (i);
	if (j == sent.size()) return false;

	//   ,   
	if (GetGramTab()->IsParticle(Wj.m_lemma, Wj.GetPoses()))
		j = get_next_main_word (j);
	if (j == sent.size()) return false;

	if ( ( !is_morph_predk(Wj) ) ||	(Wj.m_UnitType == EClause))
		return false;

	G.m_GroupType = ADV_PREDIK;	
	G.m_MainGroup = get_maximal_group(j);
	G.m_iLastWord = G.m_MainGroup.m_iLastWord;
	for (size_t k=get_main_word(G.m_iFirstWord); k != j; k  = get_next_main_word(k))
		create_syn_rel(G, j, k, ADV_PREDIK);
	return true;
}


// :
//		 
//		   
//		   
//		     

bool CRusFormatCaller::format_for_adv_verb(CGroup& G)
{
	const CGroup& G1 = get_maximal_group(G.m_iFirstWord);
	if (G1.m_iLastWord+1 >= sent.size()) return false;
	const CGroup& G2 = get_maximal_group(G1.m_iLastWord+1);

	const CSynPlmLine& ww = sent[get_main_word(G.m_iFirstWord)];
	if( GetOpt()->m_pOborDic->FindSubConj (ww.m_lemma ) != -1 )
		return false;

	if (G1.m_GroupType == OBOROTS) return false;

	int i = get_main_word(G1.m_iFirstWord);
	if  (!is_morph_adv(sent[i])  ) return false;
	int j = get_main_word(G2.m_iFirstWord);
	if    (!is_verb_form(sent[j]) || sent[j].m_UnitType == EClause)  return false;
	G.m_iLastWord = G2.m_iLastWord;
	G.m_GroupType = ADV_VERB;
	create_syn_rel(G, j, i, ADV_VERB);
	G.m_MainGroup =  G2;
	return true;
}
