// ==========  This file is under  LGPL, the GNU Lesser General Public Licence
// ==========  Dialing Syntax Analysis (www.aot.ru)
// ==========  Copyright by Dmitry Pankratov, Igor Nozhov, Alexey Sokirko


#include "StdSynan.h"
#include "RusSentence.h"


/*

          
          
   . ,    .
        ,    .
  ,   "  ",    
      "".
*/

void CRusSentence::SolveAmbiguityUsingRuleForShortAdj()
{
	for(int i = 0 ; i < m_Words.size(); i++ )
	{
		CWord& word = m_Words[i];
		int iHom;
		bool bAdj;
		if (AllHomonymsArePredicates(word)) continue;

		if(    (bAdj = word.IsThisPartOfSpeech(ADJ_SHORT, iHom, 0))
			|| word.IsThisPartOfSpeech(PARTICIPLE_SHORT, iHom, 0) 
			)
		{
			bool bFound = false;
			CHomonym& hom = word.GetHomonym(iHom);

			for(int j = 0 ; j < m_Words.size(); j++ )
			{
				if( j != i)
				{
					const CWord& word1 = m_Words[j];					
					for(int k = 0 ; k < word1.GetHomonymsCount() ; k++)
					{
						const CHomonym& hom1 = word1.GetHomonym(k);
						if (  hom1.IsSynNoun()  )
							if( GetRusGramTab()->GleicheSubjectPredicate( hom1.m_GramCodes.c_str(), hom.m_GramCodes.c_str()  ))
							{
								bFound = true;
								break;
							}
					}
				}
			}
			
			if( !bFound )
				if( bAdj )
					word.KillHomonymOfPartOfSpeech(ADJ_SHORT);
				else
					word.KillHomonymOfPartOfSpeech(PARTICIPLE_SHORT);
		}
	}
}



void CRusSentence::SolveAmbiguityUsingRuleForTwoPredicates(int iFirstWord, int iLastWord)
{
	
	for(int POS = 0 ; POS < GetRusGramTab()->GetPartOfSpeechesCount(); POS++)
	if ( GetRusGramTab()->IsStrongClauseRoot(1 << POS) )
	{
		int iWord = FindWordWithOneHomonym(iFirstWord, iLastWord, POS);

		if (iWord == -1) continue;

		for(int j = iFirstWord ; j <= iLastWord ; j++ )
		{

			//      ,         . 
			if (	HasAnalyticalBe( m_Words[j]) ) continue;

			if( j == iWord ) continue;

			for(int k = 0 ; k < GetRusGramTab()->GetPartOfSpeechesCount(); k++)
			if ( GetRusGramTab()->IsStrongClauseRoot(1 << k) )
			{
				if(k == VERB)  //         .   , .
					continue;


				// //      ,            
				if(	HasAnalyticalBe( m_Words[iWord]) )
					if(		( k == PARTICIPLE_SHORT )
						||	( k == ADJ_SHORT )
						||	( k == PREDK) 
					  )
					continue;

				m_Words[j].KillHomonymOfPartOfSpeech(k);
			}

		}
		break;	
	}

}
