// ==========  This file is under  LGPL, the GNU Lesser General Public Licence
// ==========  Dialing Syntax Analysis (www.aot.ru)
// ==========  Copyright by Dmitry Pankratov, Igor Nozhov, Alexey Sokirko

#include "StdSynan.h"
#include "../common/rus_numerals.h"
#include "RusFormatCaller.h"




bool check_number_noun_coordination(const QWORD& number_grammems, const CSynPlmLine& Noun, const CAgramtab* piRusGramTab )
{
	if (!Noun.m_gramcodes) return false;
	if (!(Noun.GetGrammems() & (1<<rPlural))) return false;

	for(int i = 0 ; i < strlen(Noun.m_gramcodes) ; i += 2 )
	{
		QWORD gram;
		piRusGramTab->GetGrammems(Noun.m_gramcodes+i, gram);
		if (gram & (1<<rPlural))
		{
			if (number_grammems & ( (1<<rNominativ) |  (1<<rAccusativ)) ) //" ", " "
			{
				if (gram & (1<<rGenitiv))
					return true;
			}
			if (		number_grammems  //" ", "  "...
					&	gram 
					&	(		(1<<rGenitiv) 
							|	(1<<rDativ) 
							|	(1<<rInstrumentalis) 
							|	(1<<rLocativ)
						)
				)
			return true;
		};
	}

	return false ;
}


/*
:
       //  
       //  
	20  (  - )
	20 . ( )
*/
bool CRusFormatCaller::format_for_numbers (CGroup& G)
{
	if (!W1.m_word) return false;

	int i = get_main_word(G.m_iFirstWord);
	int first_main_word = i;

	if  (	(		!is_numeral(Wi)  //  ,     
				||	has_item (GetOpt()->m_pNumberAdverbsList, Wi.m_lemma) //"   "
			)
		&& ( FindInList((const char*)g_BigNumerals, g_BigNumeralsCount, Wi.m_lemma ) == -1) 
			//   ,    . 

		&& !Wi.HasFlag(fl_digits)
			//     
		)
	return false; 


	int last_main_word = i;
	bool bHasAlreadyWords = false;
	for (i = get_next_main_word(i); i !=  sent.size();  i = get_next_main_word(i))
	{
	    if  (	(		!is_numeral(Wi)
					&& (!(Wi.GetPoses() & (1 << NUMERAL_P)))
					&& !Wi.HasFlag(fl_digits) 
					&& ( FindInList((const char*)g_BigNumerals, g_BigNumeralsCount, Wi.m_lemma ) == -1)
				)
			)
        break; 
		if (Wi.HasFlag(fl_digits) && bHasAlreadyWords) 
			break;

		last_main_word = i;
		bHasAlreadyWords |= Wi.HasFlag(fl_le);
	};

    
	
	if	(		(i  < sent.size())
			&&	(FindInList((const char*)g_BigNumeralsAbbr, g_BigNumeralsCount, Wi.m_lemma ) != -1 )
		)
	{
		const CGroup& H = get_maximal_group(i);	
		if	(		(H.m_iLastWord  + 1 < sent.size())
				&&	sent[H.m_iLastWord + 1].HasFlag(fl_fullstop)
			)
			{
				 //    
				 G.m_iLastWord = H.m_iLastWord+1;
				
			}
			else
			{
				//"400  "  ""   
				G.m_iLastWord = H.m_iLastWord;;
			};

		// setting all grammems if abbrevation occurs
		sent[i].SetGrammems ( GetMaxQWORD() );
		last_main_word = i;
	}
	else
	{
		if (last_main_word  ==  first_main_word) return false;    

		G.m_iLastWord = get_maximal_group(last_main_word).m_iLastWord;;
	}


	
	
	G.m_GroupType = NUMERALS;
	const CGroup& MainGroup = get_maximal_group(last_main_word);
	G.m_MainGroup = MainGroup;
	G.SetGrammems( MainGroup.GetGrammems() );
	string debug = GetGramTab()->GrammemsToStr(G.GetGrammems());
		
	for (i = G.m_iFirstWord; i < G.m_iLastWord; i++)
		create_syn_rel (G, i+1,i, NUMERALS);

	

	if (     ( FindInList((const char*)g_BigNumerals, g_BigNumeralsCount, sent[G.m_iLastWord].m_lemma ) != -1 )
			&&  (sent[G.m_iLastWord].GetGrammems() &  (1<<rGenitiv))
		)
	{
		if (sent[G.m_iFirstWord].HasFlag(fl_digits) )
			G.SetGrammems(G.GetGrammems() | _QM(rNominativ) |  _QM(rAccusativ));
		else
			if (   (   (sent[G.m_iLastWord - 1].HasFlag(fl_small_number))
					&& (sent[G.m_iLastWord - 1].GetGrammems() & _QM(rNominativ) )
					&& (sent[G.m_iLastWord].GetGrammems() & _QM(rSingular) )
					)
					||
					(   !sent[G.m_iLastWord - 1].HasFlag(fl_small_number)
					&& (sent[G.m_iLastWord - 1].GetGrammems() & _QM(rNominativ) )
					&& (sent[G.m_iLastWord].GetGrammems() & _QM(rPlural) )
					)
				)
				G.SetGrammems( _QM(rNominativ) |  _QM(rAccusativ) | _QM(rPlural));
	};

	for (i =G.m_iFirstWord; i <=  G.m_iLastWord; i++)
		if (    ( FindInList((const char*)g_BigNumerals, g_BigNumeralsCount, sent[i].m_lemma ) != -1)
				|| ( FindInList((const char*)g_BigNumeralsAbbr, g_BigNumeralsCount, sent[i].m_lemma ) != -1 )
			)
			G.m_bNumeralMoreThanThousand = true;

	return true;
};

// :
//    22,6 

bool CRusFormatCaller::format_for_num_complex (CGroup& G)
{
	if  (		(G.m_iFirstWord + 2 >= sent.size())
			|| !W1.HasFlag(fl_digits)
			|| !W2.HasFlag(fl_punct)
			|| !W3.HasFlag(fl_digits)
	 )
	return false;

	if (get_maximal_group_size(G.m_iFirstWord) != 1) return false;
	if (get_maximal_group_size(G.m_iFirstWord+2) != 1) return false;

	G.m_iLastWord = G.m_iFirstWord + 2;
	if( G.m_iLastWord + 1 < sent.size() )
	{
		if( sent[G.m_iLastWord + 1].HasFlag(fl_month) )
			return false;
	}

	if (sent[G.m_iLastWord].HasFlag(fl_has_space_before))
			return false;

	G.m_Cause = "     ";
	G.m_GroupType = C_NUMERALS;
	G.SetGrammems( sent[G.m_iLastWord].GetGrammems());
	G.m_MainGroup = G.m_iFirstWord;

	for (size_t i = G.m_iFirstWord; i < G.m_iLastWord; i++)
	   create_syn_rel (G, i+1,i, C_NUMERALS); 

	return true; 
};


// :
//     26 
//    . 26     //  
//    .  27.1

bool CRusFormatCaller::format_for_noun_num (CGroup& G)
{
	int i =  get_main_word(G.m_iFirstWord);
	//  G.m_iLastWord = G.m_iFirstWord+get_maximal_group_size(G.m_iFirstWord);
	G.m_iLastWord = get_maximal_group(G.m_iFirstWord).m_iLastWord + 1;
	if (G.m_iLastWord >= sent.size()) return false;
	if (sent[G.m_iLastWord].is_single_punct((unsigned char)'.')) G.m_iLastWord++; 
	if (G.m_iLastWord >= sent.size()) return false;
	int k =  get_main_word(G.m_iLastWord);
	
	if (		!is_numeral(Wk)
		&&	!( Wk.GetPoses() & (1 << NUMERAL_P ) ) 
		&&	!Wk.HasFlag(fl_digits)
		) 
	return false;

	//   " ",  "" - 
	if (has_item (GetOpt()->m_pNumberAdverbsList, Wk.m_lemma)) return false;
	if (!has_item (GetOpt()->m_pNounNumList, (!Wi.has_lemma() ? Wi.m_word : Wi.m_lemma))) return false;

	G.m_GroupType = NOUN_NUMERAL;
	
	G.m_iLastWord += get_maximal_group_size(G.m_iLastWord)-1;
	const CGroup& MainGroup = get_maximal_group(G.m_iFirstWord);
	G.m_MainGroup = MainGroup;
	G.SetGrammems( Wi.GetGrammems() );  
	create_syn_rel(G,get_main_word_in_group(MainGroup),get_main_word_in_group(get_maximal_group(G.m_iLastWord)), NOUN_NUMERAL);
	return true;
};



size_t get_number_with_this_case(const CSynPlmLine& L,rGrammems Case, const CAgramtab* piRusGramTab )
{
	unsigned int ret_gram = 0;
	if (!L.m_gramcodes) return 0;
	for(int i = 0 ; i < strlen(L.m_gramcodes) ; i += 2 )
	{
		QWORD gram;
		piRusGramTab->GetGrammems(L.m_gramcodes+i, gram);
		if( gram & _QM(Case))
		{
			if( gram & _QM(rPlural))
				ret_gram |= _QM(rPlural);

			if( gram & ( 1 << rSingular))
				ret_gram |=  _QM(rSingular);
		}
	}

	return ret_gram ;
}


// ---  
//   
//    

bool CRusFormatCaller::format_for_number_adverb (CGroup& G)
{
  int j = get_main_word(G.m_iFirstWord);
  if( !is_numeral(Wj) )	  return false;
  if (!has_item (GetOpt()->m_pNumberAdverbsList, Wj.m_lemma)) 
	  return false;
  if (get_maximal_group(j).m_iLastWord + 1 >= sent.size()) 
	  return false;

  int i =  get_main_word(get_maximal_group(j).m_iLastWord + 1);
  if( i <= get_maximal_group(G.m_iFirstWord).m_iLastWord )
	  return false;
  
  /*
   ,    " "   "",
   	 "   "   "I want more than you",
      "I want bigger than you"
      morph_noun
  .*/
  if (!Wi.is_syn_noun()) return false;

  if ( FindInList((const char*)g_BigNumerals, g_BigNumeralsCount, Wi.m_lemma ) != -1) 
   return false;

  

  G.m_iLastWord =  get_maximal_group(i).m_iLastWord;

  if( G.m_iLastWord >= sent.size() )
	  return false;
  G.m_Cause = "  +( )";
  G.m_GroupType = NUMERAL_ADVERB;
  const CGroup& MainGroup = get_maximal_group(i);
  G.m_MainGroup = MainGroup;

 if( is_numeral(Wj) )
 {

     if   (!(     ( (     Wj.has_grammem(rNominativ) 
		               || ((Wj.GetGrammems() & rAllCases) == 0)  // "", ""
					)       
					&& Wi.has_grammem(rGenitiv) 
				  )
              ||  (	   Wj.has_grammem(rGenitiv)        
					&& Wi.has_grammem(rGenitiv) 
				  )
              ||  (   Wj.has_grammem(rDativ)          
			       && Wi.has_grammem(rDativ) 
				  )
              ||  (    Wj.has_grammem(rAccusativ)      
			        && Wi.has_grammem(rGenitiv) 
				  )
              ||  (    Wj.has_grammem(rInstrumentalis) 
			       &&  Wi.has_grammem(rInstrumentalis) 
				  )
              ||  (    Wj.has_grammem(rLocativ)        
			       &&  Wi.has_grammem(rLocativ)
				  ) 
		   ))
		   return false;

 	 int number = rPlural;
	 if(    Wj.has_grammem(rNominativ) 
		 || Wj.has_grammem(rAccusativ) 
		 //   " "()  " " ()
		 || ((Wj.GetGrammems() & rAllCases) == 0) // ,  
		 )
	 {
		unsigned int numbers = get_number_with_this_case(Wi, rGenitiv, GetGramTab());
		if( (numbers & (1 << rSingular)) && !(numbers & (1 << rPlural)))
			number = rSingular;
	 }

     
	 if  (     ( Wj.has_grammem(rNominativ) && Wj.has_grammem(rAccusativ) )
		   ||  ((Wj.GetGrammems() & rAllCases) == 0)
		 )
	 {
		change_words_in_group_grammems(get_maximal_group(i), (1 << rGenitiv) | (1 << number), rAllCases | rAllNumbers);
		if ((Wj.GetGrammems() & rAllCases) == 0) // ,  
			G.SetGrammems( _QM(rAccusativ) | _QM(rNominativ) | _QM(rPlural) | _QM(rSingular));
		else
			G.SetGrammems( Wj.GetGrammems() );

	 }
	 else
	 {
		 G.SetGrammems( Wj.GetGrammems() & Wi.GetGrammems());
		change_words_in_group_grammems(get_maximal_group(i), (Wi.GetGrammems() & Wj.GetGrammems()) | (1 << rPlural), rAllCases | rAllNumbers);
	 }
	
	 G.SetGrammems( G.GetGrammems() | _QM(number));

 }

 create_syn_rel(G, get_main_word_in_group(MainGroup),get_main_word(G.m_iFirstWord), NUMERAL_ADVERB);
 return true;
};

bool CRusFormatCaller::is_small_number_group (size_t WordNo)
{
	if( WordNo >= sent.size() )
		return false;

  int i = get_maximal_group_no(WordNo);
  if  (i == -1)
	  return sent[WordNo].HasFlag(fl_small_number);
	else
	{
		if( sent[GetGroups()[i].m_iLastWord].HasFlag(fl_small_number) )
			return true;
	}
	return false;

};

bool NumberLikeAdj (const CSynPlmLine& L) 
{
 return    L.is_word_upper("1") 
	    || L.is_lemma(""); 
	 
};



/*
      + :
	" "
	"  "
*/
bool CRusFormatCaller::format_for_both(CGroup& G)
{
	if( G.m_iFirstWord + 1 >= sent.size() )
		return false;

	//    
	if( get_maximal_group_size(G.m_iFirstWord) > 1 )
		return false;
	
	if( get_maximal_group_size(G.m_iFirstWord + 1) > 1)
		return false;

	int i_number = -1, i_noun = -1;

	if( sent[G.m_iFirstWord].is_lemma( "") )
	{
		i_number = G.m_iFirstWord;
		if	(		!(( sent[G.m_iFirstWord+1].tag_id == PRONOUN ) 
				&&	( sent[G.m_iFirstWord+1].GetGrammems() & _QM(rPlural) )) 
			)
			return false;
		else
			i_noun = G.m_iFirstWord+1;
	}
	else
		if(		( sent[G.m_iFirstWord].tag_id == PRONOUN ) 
			&&	( sent[G.m_iFirstWord].GetGrammems() & _QM(rPlural) ))  
		{
			i_noun = G.m_iFirstWord;
			if( sent[G.m_iFirstWord + 1].is_lemma("") )
				i_number = G.m_iFirstWord + 1;
			else
				return false;
		}

	if( (i_number == -1) || (i_noun == -1) )
		return false;
	
	if( sent[i_number].GetGrammems() & sent[i_noun].GetGrammems()  & rAllCases )
	{
		G.m_iLastWord = (i_number > i_noun) ? i_number : i_noun;
		G.SetGrammems( sent[i_noun].GetGrammems() );
		G.m_GroupType = NUMERAL_NOUN;
		const CGroup& MainGroup = get_maximal_group(i_noun);
		G.m_MainGroup = MainGroup;				
		create_syn_rel(G, get_main_word_in_group(MainGroup),i_number, NUMERAL_NOUN);
		return true;
	}
	return false;
	
}


/*
   (i_noun)   (i_number).
 change_grammems true,      .
new_group_grammems -    (C-).
bAdjShouldBeInGenitivOrNominativ - ,   ,      
     ,   .
*/
bool CRusFormatCaller::gleiche_for_small_numbers(int i_noun, int i_number, bool change_grammems, QWORD& new_group_grammems, bool& bAdjShouldBeInGenitivOrNominativ)
{
	bAdjShouldBeInGenitivOrNominativ = false;

	int i_first_noun , i_noun_group  , i_last_noun, i_number_group;
	QWORD	noun_grammems , number_grammems;

	i_first_noun = get_maximal_group(i_noun).m_iLastWord ;

	i_noun_group  = get_maximal_group_no(i_first_noun);

	if( !is_noun_group(i_first_noun) ) 
		return false;

	if(i_noun_group == -1 )
	{
		i_last_noun = i_first_noun;
		noun_grammems = sent[i_first_noun].GetGrammems();
	}
	else
	{
		i_last_noun = GetGroups()[i_noun_group].m_iLastWord;
		noun_grammems = GetGroups()[i_noun_group].GetGrammems();
	}

	i_number_group = get_maximal_group_no(i_number);

	if(i_number_group == -1 )
		number_grammems = sent[i_number].GetGrammems();
	else
		number_grammems = GetGroups()[i_number_group].GetGrammems();	



	if( sent[i_number].HasFlag(fl_digit) )
	{
		if(		!(((noun_grammems & _QM(rGenitiv)) &&
				   (noun_grammems & _QM(rSingular)))
			||	
				((noun_grammems & _QM(rPlural)) && 
				(!(noun_grammems & _QM(rNominativ))))))

				return false;

		bAdjShouldBeInGenitivOrNominativ = (noun_grammems & _QM(rGenitiv)) > 0;
		
		if(	(noun_grammems & _QM(rGenitiv)) &&  (noun_grammems & _QM(rSingular)))
			new_group_grammems = _QM(rSingular) | _QM(rNominativ) | _QM(rAccusativ) | _QM(rGenitiv);
		else
			new_group_grammems = noun_grammems;

		if( change_grammems )
			change_words_in_group_grammems(get_maximal_group(i_last_noun), new_group_grammems, rAllCases | rAllNumbers);
		return true;
	}
	else
	{
		size_t i_last_number = get_maximal_group(i_number).m_iLastWord;
		bool bFirstCase = false;
		const char* word = sent[i_last_number].m_word_upper;
		if (!word) return false;

		if( !strcmp(word, "") ||
			!strcmp(word, "") ||
			!strcmp(word, "") 
			)
		{
			//    :
			//      
			if	(		(		(noun_grammems & _QM(rMasculinum)) 
							||	(noun_grammems & _QM(rNeutrum))
						) 
					&&	(noun_grammems & _QM( rGenitiv)) 
				)
			{
				if (!sent[i_noun].HasFlag(fl_noun_has_adj_declination) )
				{
					if (noun_grammems & _QM(rSingular))
					{
						// "  "
						// "  "
						if( change_grammems )
						{
							change_words_in_group_grammems(
									get_maximal_group(i_last_noun),
									_QM(rMasculinum)|_QM(rNeutrum)|_QM(rGenitiv)|_QM(rSingular), 
									rAllCases | rAllNumbers);
						}

						bFirstCase = true;
					}
				}
				else	//  
					if	(noun_grammems & _QM(rPlural))
					{
						// "  "
						bFirstCase = true;
						if( change_grammems )
						{
							change_words_in_group_grammems(
									get_maximal_group(i_last_noun),
									_QM(rMasculinum)|_QM(rNeutrum)|_QM(rGenitiv)|_QM(rPlural), 
									rAllCases | rAllNumbers);
						}
		
					};

			}
		} 
		else

		if( !strcmp(word, "") ||
			!strcmp(word, "") ||
			!strcmp(word, "") )
		{
			// 
			if (noun_grammems & _QM(rFeminum))

			if(		!sent[i_noun].HasFlag(fl_noun_has_adj_declination) )
			{
				if (		(noun_grammems & _QM(rGenitiv)) 
						&&	(noun_grammems & _QM(rSingular))
					) 
				{
					if( change_grammems )
					{
						change_words_in_group_grammems(
							get_maximal_group(i_last_noun),
							_QM(rGenitiv)|_QM(rSingular), 
							rAllCases | rAllNumbers);
					};
				
					bFirstCase = true;
				}
			}
			else	// 
				if (		(noun_grammems & _QM(rNominativ)) 
						&&	(noun_grammems & _QM(rPlural))
					) 
				{
					// " "
					if( change_grammems )
					{
						change_words_in_group_grammems(
							get_maximal_group(i_last_noun),
							_QM(rNominativ)|_QM(rPlural), 
							rAllCases | rAllNumbers);
					};
				
					bFirstCase = true;
				}
				
		} else
		if( !strcmp(word, "") ||
			!strcmp(word, "")) 
		{
			if( (noun_grammems & _QM(rGenitiv)) &&
				(noun_grammems & _QM(rSingular))) 
			{
				if( change_grammems )
				{
					change_words_in_group_grammems(
								get_maximal_group(i_last_noun),
								_QM(rGenitiv)|_QM(rSingular), 
								rAllCases | rAllNumbers);				
				}
				bFirstCase = true;
			}

			if (		sent[i_noun].HasFlag(fl_noun_has_adj_declination) 
					&&	(noun_grammems & _QM(rFeminum))
				)
			{
				//  
				if( change_grammems )
				{
					change_words_in_group_grammems(
								get_maximal_group(i_last_noun),
								_QM(rNominativ)|_QM(rPlural), 
								rAllCases | rAllNumbers);				
				}
				bFirstCase = true;

			};
		}

		if( bFirstCase )
		{
			bAdjShouldBeInGenitivOrNominativ = true;
			if( noun_grammems & _QM(rAnimative ))
				new_group_grammems = _QM(rPlural) | _QM(rNominativ);
			else
				new_group_grammems = _QM(rPlural) | _QM(rNominativ) | _QM(rAccusativ);

			return true;
		}

		
		if(noun_grammems  & _QM(rPlural)) // " ", " ", " ", " "
			if( number_grammems & rAllCases & noun_grammems )
			{
				
				if (number_grammems & _QM(rNominativ) ) // "", "", ""
					if	(		(number_grammems & _QM(rAccusativ) & noun_grammems )  //  " "
							||	sent[i_noun].HasFlag(fl_noun_has_adj_declination) //  " "
						)
					{
						return false;
					};


				new_group_grammems = (number_grammems & rAllCases & noun_grammems) |  _QM(rPlural);
				if( change_grammems )
					change_words_in_group_grammems(get_maximal_group(i_last_noun), new_group_grammems, rAllCases | rAllNumbers);
				return true;			
			}	
			
	}	
	return false;
}




bool CRusFormatCaller::format_for_small_number_noun(CGroup& G)
{
	try
	{

		size_t i_first_noun,  i_last, i_number, i_last_noun;
		int i_noun_group;
		EGroupType type;
		
		int i_first = get_main_word (G.m_iFirstWord);

		if  (  is_numeral(sent[i_first])  
		  || sent[i_first].HasFlag(fl_digit))
		{
			i_number = i_first;
			i_first_noun = get_maximal_group(G.m_iFirstWord).m_iLastWord + 1;

			if( i_first_noun >= sent.size() )
				return false;

			i_noun_group  = get_maximal_group_no(i_first_noun);

			i_last = get_maximal_group(i_first_noun).m_iLastWord;

			if( !is_noun_group(i_first_noun) ) 
				return false;

			if(i_noun_group == -1 )			
				i_last_noun = i_first_noun;							
			else			
				i_last_noun = GetGroups()[i_noun_group].m_iLastWord;			

			type = NUMERAL_NOUN;
		}
		else
			if( is_noun_group(i_first) )
			{
				i_first_noun = i_first;
				i_noun_group  = get_maximal_group_no(i_first);

				if(i_noun_group == -1 )
					i_last_noun = i_first_noun;
				else
					return false;

				i_number = get_maximal_group(i_first).m_iLastWord + 1;

				if( i_number >= sent.size() )
					return false;

				i_number = get_main_word(i_number);

				if(    !is_numeral(sent[i_number] ) 
					&& !sent[i_number].HasFlag(fl_digit)
				  )
					return false;
				
				i_last = get_maximal_group(i_number).m_iLastWord;
				type = NOUN_NUMERAL_APPROX;
			}
			else
				return false;					

		
		bool dummi;
		QWORD grammems  = G.GetGrammems();
		if( gleiche_for_small_numbers(i_last_noun, i_number, true, grammems , dummi) )
		{
			G.SetGrammems(grammems);
			G.m_iLastWord = i_last;						
			G.m_GroupType = type;

			const CGroup& MainGroup = get_maximal_group(i_last_noun);
			G.m_MainGroup = MainGroup;		
			create_syn_rel(G, get_main_word_in_group(MainGroup),i_number, type);
			return true;
		}

		return false;
	}
	catch(...)
	{
		return false;
	}
}


bool CRusFormatCaller::format_for_odin_group(CGroup& G)
{
	int i_number = get_main_word (G.m_iFirstWord);
	if(    !sent[i_number].HasFlag(fl_digit)
		&& !(sent[i_number].GetPoses() & ( 1<< NUMERAL)) 
	  )
		return false;

	int i_noun = get_main_word(get_maximal_group(G.m_iFirstWord).m_iLastWord + 1);
	if(  i_noun >= sent.size() )
		return false;
	if( !is_noun_group(i_noun) )
		return false;

	if( sent[i_number].HasFlag(fl_digit) )
	{
		G.m_iLastWord = get_maximal_group(G.m_iFirstWord).m_iLastWord + get_maximal_group_size(i_noun);
		G.SetGrammems( sent[i_noun].GetGrammems());
	}
	else
		if( !GetGramTab()->GleicheGenderNumberCase(sent[i_noun].m_type_gram_code,sent[i_noun].m_gramcodes, sent[i_number].m_gramcodes ) )
		{
			G.m_iLastWord = get_maximal_group(G.m_iFirstWord).m_iLastWord + get_maximal_group_size(i_noun);
			G.SetGrammems(  sent[i_noun].GetGrammems() & sent[i_number].GetGrammems() );
			change_words_in_group_grammems(G, G.GetGrammems(), (rAllNumbers | rAllCases));
		}
		else
			return false;
	
	G.m_GroupType = NUMERAL_NOUN;

	const CGroup& MainGroup = get_maximal_group(G.m_iLastWord);
	G.m_MainGroup = MainGroup;
	create_syn_rel(G, get_main_word_in_group(MainGroup),i_number, NUMERAL_NOUN);

	return true;
}



static bool is_odin_number_group(const CRusFormatCaller& F, size_t WordNo)
{
	int i = F.get_maximal_group_no(WordNo);
	if( i != -1)
	{
		return F.sent[F.GetGroups()[i].m_iLastWord].HasFlag(fl_russian_odin); 
			
	}
	else
	{
		return F.sent[WordNo].HasFlag(fl_russian_odin);
	}
}

bool CRusFormatCaller::format_for_approx_noun_number(CGroup& G)
{
	if  (is_small_number_group( get_maximal_group(G.m_iFirstWord).m_iLastWord + 1)) 	
		return format_for_small_number_noun(G);	
 
	size_t i_first = G.m_iFirstWord;
	if( !is_noun_group(i_first) )
		return false;

	size_t i_first_noun,   i_last, i_number;
	int i_number_group, i_noun_group;
	size_t noun_grammems;
	size_t i_last_noun;
	size_t number_grammems;
	
	i_first_noun = i_first;
	i_noun_group  = get_maximal_group_no(i_first);

	if(i_noun_group == -1 )
	{
		i_last_noun = i_first_noun;
		noun_grammems = sent[i_first_noun].GetGrammems();
	}
	else
		return false;

	if( !sent[i_first_noun].has_grammem(rPlural) )
		return false;

	i_number = get_maximal_group(i_first).m_iLastWord + 1;

	if( i_number >= sent.size() )
		return false;

	i_number = get_main_word(i_number);

	if (sent[i_number].m_UnitType == EClause) return false;

	if( NumberLikeAdj(sent[i_number]) )
		return false;

	if( is_numeral(sent[i_number]) )
	{
		//    ""  ""    _
		if (GetCardinalNumeral(sent[i_number].m_lemma) == -1)
			return false;
	}
	else
		if(!sent[i_number].HasFlag(fl_digit) )
		return false;

	


	/*
	 (1)
	   " /"
	   " /"
	 ..   
	*/
	if (sent[i_number].HasFlag(fl_digit) )
	{
		if	(		!sent[i_number].m_word 
				||	strlen(sent[i_number].m_word) > 3 // = "5000"
			) 
		return false;
	};
    
	i_number_group = get_maximal_group_no(i_number);

	if(i_number_group == -1 )
	{
		number_grammems = sent[i_number].GetGrammems();
		// .  (1)
		if ( FindInList((const char*)g_BigNumerals, g_BigNumeralsCount, sent[i_number].m_lemma ) != -1)
		return false;
	}
	else
	{
		if( GetGroups()[i_number_group].m_GroupType != NUMERALS )
			return false;
		// .  (1)
		if (GetGroups()[i_number_group].m_bNumeralMoreThanThousand)
			return false;
		if( !( sent[GetGroups()[i_number_group].m_iLastWord].GetPoses() & (1 << NUMERAL)) )
			return false;
		number_grammems = GetGroups()[i_number_group].GetGrammems();			
	}

	i_last = get_maximal_group(i_number).m_iLastWord;

	if   ( !check_number_noun_coordination(number_grammems, sent[i_first_noun], GetGramTab()) )
    	   if( !sent[i_number].HasFlag(fl_digit) )
				return false;
	

	 if( sent[i_number].has_grammem(rNominativ) || sent[i_number].has_grammem(rAccusativ) )
		change_words_in_group_grammems(get_maximal_group(i_first_noun), (1 << rGenitiv) | (1 << rPlural), rAllCases | rAllNumbers);
	 else
		 if( !sent[i_number].HasFlag(fl_digit) )
			change_words_in_group_grammems(get_maximal_group(i_first_noun), (noun_grammems & number_grammems) | (1 << rPlural), rAllCases | rAllNumbers);


     G.m_GroupType = NOUN_NUMERAL_APPROX;

     G.m_MainGroup = get_maximal_group(i_first_noun);

	if( sent[i_number].HasFlag(fl_digit) )
			if( sent[i_first_noun].has_grammem(rGenitiv) )
				G.SetGrammems( _QM(rNominativ) |	_QM(rAccusativ)  |	_QM(rGenitiv) );
			else
				G.SetGrammems( sent[i_first_noun].GetGrammems() );
	else
		G.SetGrammems( sent[i_number].GetGrammems() );

	G.SetGrammems(G.GetGrammems() | _QM(rPlural) );	

	G.m_iLastWord =  i_number;
    

    return true;
		   

	
}


/*
   ,    StartWordNo    _.
 ,    StartWordNo       
 .     ,   
   .    -1.
*/

int CRusFormatCaller::can_start_number_noun_group (int StartWordNo) const
{
	 int i = get_main_word (StartWordNo);
     if  (  !is_numeral(sent[i])
		  && !sent[i].HasFlag(fl_digit)
		  && !( get_maximal_group(i).m_GroupType == NUMERALS ) 
		 )
     return -1;

	 int gr_num = get_maximal_group_no(StartWordNo);
	 if( gr_num != -1 )
		 if  (GetGroups()[gr_num].m_GroupType == NOUN_NUMERAL) 
		    return -1;


	 int k = get_minimal_group (StartWordNo);

	 if   (    ( k == -1) 
		    && NumberLikeAdj(sent[StartWordNo])
		  ) 
     return -1; 

	 k = get_maximal_group(StartWordNo).m_iLastWord + 1;

	 if  (k >= sent.size()) return -1;

	 k = get_main_word (k);

	 return k;
};

bool CRusFormatCaller::format_standard_param_abbr(CGroup& G)
{
	/*
	   "20 "  " "(?)     ,
	     
	*/
    int  k = can_start_number_noun_group(G.m_iFirstWord);

    if (k == -1) return false;

	if (!sent[k].HasFlag(fl_standard_param_abbr))
		return false;

	G.SetGrammems( rAllCases |  _QM(rPlural) );

	G.m_Cause = "  + ";


	G.m_GroupType = NUMERAL_NOUN;

	const CGroup&  MainGroup = get_maximal_group(k);

	G.m_iLastWord =  MainGroup.m_iLastWord;

	G.m_MainGroup = MainGroup;

	create_syn_rel(G, get_main_word_in_group(MainGroup), get_main_word (G.m_iFirstWord), NUMERAL_NOUN);

	return true;
};

bool CRusFormatCaller::format_for_number_noun (CGroup& G)
{
  if (has_item (GetOpt()->m_pNumberAdverbsList, W1.m_lemma)) 
	  return false;

  if (get_maximal_group(G.m_iFirstWord).m_GroupType == SELECTIVE_GR)
	  return false;

 if( format_for_both(G) )
	 return true;

 if (format_standard_param_abbr(G))
	 return true;

 if  (is_small_number_group (G.m_iFirstWord) ) 	 
 {
   return format_for_small_number_noun(G);	
 }
 else if( is_odin_number_group(*this, G.m_iFirstWord) )
 {
	return format_for_odin_group(G);
 }
 else
 {
	 int  k = can_start_number_noun_group(G.m_iFirstWord);

	 if (k == -1) return false;
	 	 
	 if(!sent[k].is_morph_noun() )
		return false;


	 if (!Wk.has_grammem(rIndeclinable)) // " "
		if  (!Wk.has_grammem(rPlural))  return false; 

	 int i = get_main_word (G.m_iFirstWord);

	 if   ( !check_number_noun_coordination(Wi.GetGrammems(), Wk, GetGramTab()) )
		 
		   if( !sent[i].HasFlag(fl_digit) )
				return false;
		   else 
		   {
				if ((Wk.GetGrammems() & rAllCases) != rAllCases)
				if ( Wk.has_grammem(rNominativ)) //      _ "1999 "
						return false;
		   } 
	 /*
	         ,
	        , :
	   "   "
	   "  "
	      ,      
	    .
	 */

	 int gr_num = get_maximal_group_no(G.m_iFirstWord);
	 QWORD grams = (gr_num != -1) ? GetGroups()[gr_num].GetGrammems() : Wi.GetGrammems();
	 bool NumeralInNomOrAcc =
			// - " " 
			//  "  " ( .   )
			(		(grams & ((1 << rAccusativ) | (1<<rNominativ)))   
				&&	((grams & rAllCases) != rAllCases)
			);
	 

	 if(NumeralInNomOrAcc)
		change_words_in_group_grammems(get_maximal_group(k), (1 << rGenitiv) | (1 << rPlural), rAllCases | rAllNumbers);
	 else
		 if( !sent[i].HasFlag(fl_digit) )
			change_words_in_group_grammems(get_maximal_group(k), (Wi.GetGrammems() & Wk.GetGrammems()) | (1 << rPlural), rAllCases | rAllNumbers);


	if( sent[i].HasFlag(fl_digit) )
			if( Wk.has_grammem(rGenitiv) )
				G.SetGrammems( _QM(rNominativ) |	_QM(rAccusativ) | _QM(rGenitiv) );
			else

				G.SetGrammems( Wk.GetGrammems());
	else
	{
		if( NumeralInNomOrAcc )
			G.SetGrammems( ( gr_num != -1 ) ? GetGroups()[gr_num].GetGrammems() : Wi.GetGrammems());
		else
			G.SetGrammems( Wi.GetGrammems() & Wk.GetGrammems());
	}

    G.m_Cause = "  + ( )";

    G.m_GroupType = NUMERAL_NOUN;

	G.SetGrammems(G.GetGrammems() | _QM(rPlural));	

	const CGroup&  MainGroup = get_maximal_group(k);

	G.m_iLastWord =  MainGroup.m_iLastWord;
	
	G.m_MainGroup = MainGroup;

	create_syn_rel(G, get_main_word_in_group(MainGroup),i, NUMERAL_NOUN);
    return true;
 };
};


// "     "
//  "  " - _
bool CRusFormatCaller::format_for_approx_noun_prep(CGroup& G)
{
	int i_prep, i_number, i_noun = G.m_iFirstWord;	
	size_t depend_cases;
	if( !is_noun_group(i_noun) )
		return false;
	if( sent[i_noun].GetPoses() & (1 << PRONOUN) )
		return false;
	if( get_maximal_group_no(i_noun) != -1 )
		return false;
	if( get_maximal_group(i_noun).m_iLastWord == sent.size() - 1 )
		return false;
	i_prep = get_maximal_group(i_noun).m_iLastWord + 1;
	if( get_maximal_group_no(i_prep) != -1  )
		return false;

	if( i_prep == sent.size() - 1 )
		return false;

	if	(			
					!sent[i_prep].m_pSimplePrepNos
			||		 sent[i_prep].m_pSimplePrepNos->empty()
		)
		return false;
	else
	{
		depend_cases = GetOpt()->m_pOborDic->m_Entries[(*sent[i_prep].m_pSimplePrepNos)[0]].m_AllPossibleDependCases;
	}

	i_number = i_prep + 1; 
	
	if(	(  !is_small_number_group(i_number) &&
		   !is_numeral(sent[i_number])	&&
		   ( get_maximal_group(i_number).m_GroupType != NUMERALS )
		 )
	   )
	   return false;

	 if (!(depend_cases & sent[i_number].GetGrammems())) 
		 return false;

	
	if( !gleiche_noun_numeral_for_approx(i_noun, i_number) )
		return false;
		
	G.m_iLastWord = get_maximal_group(i_number).m_iLastWord;
	G.m_GroupType = APPROX_PREP_NOUN;
	G.m_MainGroup = get_maximal_group(i_prep);
	create_syn_rel(G, get_main_word(i_prep),get_main_word(i_noun), PREP_NOUN );
	create_syn_rel(G, get_main_word(i_noun),get_main_word(i_number), APPROX_PREP_NOUN );
	return true;
}

bool CRusFormatCaller::gleiche_noun_numeral_for_approx(int i_noun, int i_number)
{
	if( (i_number >= sent.size()) || (i_noun >= sent.size()))
		return false;

	int i_number_group, number_grammems, i_last_number;

	if( get_maximal_group_no(i_noun) != -1 )
		return false;

	QWORD noun_grammems = sent[i_noun].GetGrammems();

	i_number = get_main_word(i_number);
	i_last_number = get_maximal_group(i_number).m_iLastWord;

	if( NumberLikeAdj(sent[i_number]) )
		return false;

	if( !is_numeral(sent[i_number]) && !sent[i_number].HasFlag(fl_digit) )
		return false;
	
	i_number_group = get_maximal_group_no(i_number);

	if(i_number_group == -1 )
		number_grammems = sent[i_number].GetGrammems();
	else
	{
		number_grammems = GetGroups()[i_number_group].GetGrammems();			
	}

	if  (is_small_number_group( i_number ) )
	{
		if( sent[i_number].HasFlag(fl_digit) )
		{
			if(		!(((noun_grammems & (1 << rGenitiv)) &&
					   (noun_grammems & (1 << rSingular)))
				||	
					((noun_grammems & (1 << rPlural)) && 
					(!(noun_grammems & (1 << rNominativ))))))

					return false;
			
			return true;
		}
		else
		{
			size_t i_last_number = get_maximal_group(i_number).m_iLastWord;
			bool already_build = false;
			const char* word = sent[i_last_number].m_word_upper;
			if (!word) return false;

			if( !strcmp(word, "") ||
				!strcmp(word, "") ||
				!strcmp(word, "") )
			{
				if(((noun_grammems & (1 << rMasculinum)) ||
					(noun_grammems & (1 << rNeutrum))) &&
					(noun_grammems & (1 << rGenitiv)) &&
					(noun_grammems & (1 << rSingular))) 
				{
					already_build = true;
				}
			} 
			else

			if( !strcmp(word, "") ||
				!strcmp(word, "") ||
				!strcmp(word, "") )
			{
				if( (noun_grammems & (1 << rFeminum)) &&
					(noun_grammems & (1 << rGenitiv)) &&
					(noun_grammems & (1 << rSingular))) 
				{
					already_build = true;
				}
			} else

			if( !strcmp(word, "") ||
				!strcmp(word, "")) 
			{
				if( (noun_grammems & (1 << rGenitiv)) &&
					(noun_grammems & (1 << rSingular))) 
				{
					already_build = true;
				}
			}

			if( already_build )
			{
				return true;
			}

			if(noun_grammems  & (1 << rPlural))
				if( number_grammems & rAllCases & noun_grammems )
				{
					return true;			
				}
			return false;
		}
	}	
	else
	{

		if   (!(     ( (number_grammems & _QM(rNominativ))      && sent[i_noun].has_grammem(rGenitiv) )
				 ||  ( (number_grammems & _QM(rGenitiv))        && sent[i_noun].has_grammem(rGenitiv) )
				 ||  ( (number_grammems & _QM(rDativ))          && sent[i_noun].has_grammem(rDativ) )
				 ||  ( (number_grammems & _QM(rAccusativ))      && sent[i_noun].has_grammem(rGenitiv) )
				 ||  ( (number_grammems & _QM(rInstrumentalis)) && sent[i_noun].has_grammem(rInstrumentalis) )
				 ||  ( (number_grammems & _QM(rLocativ))        && sent[i_noun].has_grammem(rLocativ) ) 
		   ))
		   if( !sent[i_number].HasFlag(fl_digit) )
				return false;

		return true;
	}

	return false;

}

