// ==========  This file is under  LGPL, the GNU Lesser General Public Licence
// ==========  Dialing Syntax Analysis (www.aot.ru)
// ==========  Copyright by Dmitry Pankratov, Igor Nozhov, Alexey Sokirko

#include "StdSynan.h"
#include "RusFormatCaller.h"


// :
//   
//   

bool CRusFormatCaller::format_for_gen_chains (CGroup& G)
{
	G.m_iLastWord = G.m_iFirstWord;
	int i = get_main_word (G.m_iFirstWord);
	if ( !Wi.is_morph_noun()) return false;
	if (Wi.m_UnitType != EWord) return false;

	/*
		          
		-,  " ",
		        _
		 " " ( )	 _ .
		
	*/
	if  ( !Wi.has_grammem(rPlural))
		if (FindInList((const char*)g_BigNumerals, g_BigNumeralsCount, sent[i].m_lemma ) != -1) 
			return false;

	//   "" _   
	if (Wi.is_lemma(""))
		return false;


	 //      ,   	 
	if (G.m_iFirstWord > 0)
		{ 
			int k =  get_main_word(G.m_iFirstWord - 1);
			const CGroup& G = get_maximal_group (k);
			if( G.m_GroupType != OBOROTS )
				if (sent[G.m_MainWordNo].is_morph_noun()) 
					return false;
		};

	const CGroup& LeftGroup = get_maximal_group (i);
	if( LeftGroup.m_GroupType== NUMERALS )
		return false;

	if( LeftGroup.m_GroupType== OBOROTS )
		return false;

	int k = get_next_main_word(i);
	if (k == sent.size()) return false;

	//  ,   
	if	(GetGramTab()->IsParticle(Wk.m_lemma, Wk.GetPoses()) )
		k = get_next_main_word(k);
	if (k == sent.size()) return false;

	if (!Wk.is_morph_noun() || Wk.is_lemma("")) return false;
	const CGroup& RightGroup = get_maximal_group (k);
	if( RightGroup.m_GroupType == NUMERALS)
			return false;
	if (!(RightGroup.GetGrammems() & _QM(rGenitiv))) return false;

	if (Wk.HasFlag(fl_ambiguous)) return false;
	

	//      ,     
	// _,     _
	/*{
		int j = get_next_main_word(k);

		if( j != sent.size() )
		{
			if (Wj.is_morph_noun()) return false;

			if (		Wj.is_word_upper("") 
					||  Wj.is_word_upper("") 
					||  Wj.is_word_upper(",")
				)
			{
				j = get_next_main_word(j);
				if (Wj.is_morph_noun()) return false;
			}
		}
	}
	*/


	G.m_MainGroup = LeftGroup;
	G.m_iLastWord = RightGroup.m_iLastWord;
	G.m_GroupType = GEN_NOUN;
	G.SetGrammems( LeftGroup.GetGrammems() );


	return true;
	
};

/*
   
    
*/
bool CRusFormatCaller::format_for_from_compar (CGroup& G)
{
	int i, j, k;

	try
	{
	 G.m_iLastWord = G.m_iFirstWord;
	 i = get_main_word (G.m_iFirstWord);
	 if ( (Wi.GetGrammems()  & (1 << rComparative)) == 0) return false;
	 if ( (Wi.GetPoses() & (1 <<ADJ_FULL)) == 0) return false;

	 const CGroup& P = get_maximal_group (i);

	 k = P.m_iLastWord + 1;

	 if (k >= sent.size()) return false;
	 j = get_main_word (k);
	 if (!Wj.is_syn_noun() || Wj.is_lemma("")) return false;
	 const CGroup& H = get_maximal_group (k);
	 if( H.m_GroupType == NUMERALS)		 return false;
	 if (!(H.GetGrammems() & (1<<rGenitiv))) return false;

	 //   .    ,  . -  
	 // "    ."
	 // !!!! change_words_in_group_grammems(H, (1<<rGenitiv), rAllCases);  

	 G.m_MainGroup = P;
	 G.m_iLastWord = k + get_maximal_group_size(k) - 1;
	 G.m_Cause = "         .  ";
	 G.m_GroupType = FROM_COMPAR;
	 G.SetGrammems( 0 );

	}
	catch(...)
	{
		GetOpt()->OutputErrorString("Failed from-compar rule");	
	return false;
}


 return true;

};

