#include <stdio.h>
#include "../common/SyntaxHolder.h"


string GetStringBySyntax(const CSentencesCollection& SC, const CAgramtab& A)
{
	int nSent = SC.m_vectorSents.size();
	if (nSent == 0)
	{
		return " No sentence";
	};
	if (nSent > 1)
	{
		return "More than one sentence found";
	};

	const CSentence& Sentence = *SC.m_vectorSents[0];
	int iWord=0,iClau=0,iCvar=0;
	StringSet Groups;

	try {
	
		int nClausesCount = Sentence.GetClausesCount();
		for( int ClauseNo = 0; ClauseNo<nClausesCount; ClauseNo++ )
		{
			const CClause& Clause = Sentence.GetClause(ClauseNo);
			int nCvar = Clause.m_SynVariants.size();

			if (Clause.m_SynVariants.empty()) continue;

			int nVmax = Clause.m_SynVariants.begin()->m_iWeight;
			for( CSVI pSynVar=Clause.m_SynVariants.begin(); pSynVar != Clause.m_SynVariants.end(); pSynVar++ )
			{
				if( pSynVar->m_iWeight < nVmax ) break;

				const CMorphVariant& V = *pSynVar;

				// print the clause
				int ClauseType = (V.m_ClauseTypeNo == -1) ? UnknownSyntaxElement  :  Clause.m_vectorTypes[V.m_ClauseTypeNo].m_Type;;
			
				string S;
				if (ClauseType != UnknownSyntaxElement)
					S = (const char*)A.GetClauseNameByType(ClauseType);
				else
					S = "EMPTY";

				S += "\t=\t";
				for (int WordNo = Clause.m_iFirstWord; WordNo <= Clause.m_iLastWord; WordNo++)
				{
					S += Sentence.m_Words[WordNo].m_strWord;
					S += " ";
				};
				Groups.insert(S);

				//    
				

				for (int GroupNo = 0; GroupNo < V.m_vectorGroups.GetGroups().size(); GroupNo++)
				{
					const CGroup& G  = V.m_vectorGroups.GetGroups()[GroupNo];
					
					S = (const char*)Sentence.GetOpt()->GetGroupNameByIndex(G.m_GroupType);
					S += "\t=\t";
					for (int WordNo = G.m_iFirstWord; WordNo <= G.m_iLastWord; WordNo++)
					{
						S += Sentence.m_Words[WordNo].m_strWord;
						S += " ";
					};
					Groups.insert(S);
				};
				
			};

		};
	} 
	catch(...)
	{
		return "an exception occurred";
	}

	string Result;
	for (StringSet::const_iterator it = Groups.begin(); !(it == Groups.end()); it++)
	{
		Result += *it;
		Result += "\n";
	};

	return Result;

	//return "ddd";

};
	
extern void KOI8ToWin (string& s);
extern void WinToKOI8 (string& s);
void RussianConvertToScreen (string& S)
{
	#ifdef WIN32
		CharToOemBuff((char*)S.c_str(), (char*)S.c_str(), S.length());		
	#else
		WinToKOI8(S);
	#endif

};
void RussianConvertToDictionary (string& S)
{
	#ifdef WIN32
		OemToCharBuff((char*)S.c_str(), (char*)S.c_str(), S.length());		
	#else
		KOI8ToWin(S);
	#endif

};


void PrintUsage()
{
		printf ("Dialing DWDS Command Line Syntax Parser(www.aot.ru, www.dwds.de)\n");
		printf ("Usage: TestSynan (RUSSIAN|GERMAN)\n");
		printf ("Example: TestSynan Russian\n");
		exit(-1);	
};


int main(int argc, char* argv[])
{
try {
	

	MorphLanguageEnum langua;
	if (argc != 2) PrintUsage();
	if (!GetLanguageByString(argv[1], langua)) PrintUsage();
	CSyntaxHolder H;
	
	if (!H.LoadSyntax(langua))
	{
		fprintf (stderr, "initialization error\n");
		return 1;
	};
	
	//H.m_pGramTab->GleicheAncode1(WeakGleiche,"test", "test");
	fprintf (stderr, "ok\n");   	


	printf ("Input a sentence..\n");
	// ===============  WORKING ===============
	for (;;)
	{
		printf (">");
		char buffer[1000] ;
		fgets(buffer, 1000, stdin);
		if (strlen(buffer) == 0) break;
		string s = buffer;
		Trim(s);
		if (s.empty()) break;
		
		RussianConvertToDictionary(s);
		
		//string s = "  ";
		//string s = "die schwache Resolution";
		//string s = "test";
		H.GetSentencesFromSynAn(s, false);
		s = GetStringBySyntax(H.m_Synan, *H.m_pGramTab);
		RussianConvertToScreen(s);	
		printf  ("%s\n\n", s.c_str());
	};
}
catch(...)
{
 	fprintf (stderr, "an exception occurred!\n");   	
	return 1;
};

	return 0;
};
