# SPDX-License-Identifier: GPL-3.0-or-later

.NOTPARALLEL:
.EXPORT_ALL_VARIABLES:
.DEFAULT_GOAL := all

TESTING_PUBLIC_GOALS =

ifneq "$(MAKE_INITRD_TESTING)" ""
TESTING_PUBLIC_GOALS += test-guess
endif

ifeq "$(MAKELEVEL)" '0'
public-goals  := all guess-config guess-modules feature-info bug-report $(TESTING_PUBLIC_GOALS)
private-goals := $(filter-out $(public-goals),$(MAKECMDGOALS))

ifneq "$(private-goals)" ''
$(error You MUST NOT call private goals directly: $(private-goals))
endif
endif # MAKELEVEL = 0

include /usr/share/make-initrd/mk/config.mk

.PHONY: check-for-root depmod-host

check-for-root:
	@if [ -z "$$IGNORE_PRIV_CHECKS" ] && [ "$$(id -u)" != 0 ]; then \
	    echo "Only root can do that"; \
	    exit 1; \
	fi

depmod-host: check-for-root
	@if [ -z "$$IGNORE_DEPMOD" ]; then \
	   $(MSG) "Generating module dependencies on host ..."; \
	   system_map_file="$(BOOTDIR)/System.map-$(KERNEL)"; \
	   [ -e "$$system_map_file" ] || system_map_file=""; \
	   depmod -a $${system_map_file:+-F "$$system_map_file"} "$(KERNEL)"; \
	fi

ifeq "$(MAKECMDGOALS)" 'process-config'
STARTUP_TIME   = $(shell date +'%s')
WORKDIR_SUFFIX = $(basename $(notdir $(INITRD_CONFIG)))
endif

ifneq "$(filter guess guess-config guess-modules test-guess-actions,$(MAKECMDGOALS))" ''
AUTODETECT ?= all

ifeq "$(MAKECMDGOALS)" 'guess-modules'
AUTODETECT := root device
endif

-include $(GUESSDIR)/guessed.mk

RECENTLY_ACTIVATED_FEATURES := $(filter-out $(ALL_ACTIVE_FEATURES),$(call get-all-active-features))

GUESS_CONFIG_MODULES = \
		$(foreach mod1, \
			$(if $(findstring all,$(AUTODETECT)), \
				$(realpath $(wildcard $(DETECTDIR)/*)), \
				$(foreach mod,$(AUTODETECT),$(realpath $(DETECTDIR)/$(mod)))), \
			$(wildcard $(mod1)/config.mk))

GUESS_MODULES = \
	$(sort $(filter-out $(sort $(PASSED_GUESS_MODULES)), \
		$(if $(findstring all,$(AUTODETECT)), \
			$(notdir $(call filter-dirs,$(wildcard $(DETECTDIR)/*))), \
			$(AUTODETECT))))

-include $(GUESS_CONFIG_MODULES)

ifdef VERBOSE
$(info GUESS_MODULES        = $(notdir $(GUESS_MODULES)))
$(info PASSED_GUESS_MODULES = $(notdir $(PASSED_GUESS_MODULES)))
endif

.PHONY: pre-guess guess

pre-guess: check-for-root
	@mkdir -m 755 -p -- $(GUESSDIR)
	@for n in modules:rescue modules:add modalias:rescue modalias:add features; do \
	   :>> "$(GUESSDIR)/guess:$$n"; \
	done

ifneq "$(GUESS_MODULES)" ''
GUESS_DEVICE_SCRIPTS = $(call wildcard-features,guess/device)
GUESS_FSTYPE_SCRIPTS = $(call wildcard-features,guess/fstype)
ALL_ACTIVE_FEATURES  := $(call get-all-active-features)

include \
	$(sort $(filter-out \
		$(foreach exl,$(DISABLE_GUESS),$(realpath $(exl:%=$(DETECTDIR)/%/rules.mk))), \
		$(foreach mod,$(GUESS_MODULES),$(realpath $(DETECTDIR)/$(mod)/rules.mk))))

guess: pre-guess
	$V printf '============================================================\n\n' >&2
	@$(TOOLSDIR)/guess-config > $(GUESSDIR)/guessed.mk
	$V printf '============================================================\n\n' >&2
	@$(VMSG) "Guessing config ..."
	@$(MAKE) $(MFLAGS) -f /usr/share/make-initrd/mk/make-initrd.mk guess PASSED_GUESS_MODULES+="$(GUESS_MODULES)"

test-guess-actions: pre-guess
	@[ -n "$(TEST_GUESS_ACTIONS)" ] || { printf "TEST_GUESS_ACTIONS not specified\n" >&2; exit 1; }
	@for exe in $(TEST_GUESS_ACTIONS); do echo "RUN: $$exe"; "$$exe"; done

else # !GUESS_MODULES

unknown_features = \
	$(filter-out \
		$(notdir $(wildcard $(FEATURESDIR)/*)), \
		$(sort $(FEATURES)))
ifneq "$(unknown_features)" ''
$(info WARNING: Unknown features are specified in the config: $(unknown_features))
endif

guess: depmod-host
	@$(VMSG) "Guessing is complete"

endif # GUESS_MODULES
endif # MAKECMDGOALS = guess guess-config guess-modules

ifeq "$(MAKECMDGOALS)" 'genimage'
-include $(GUESSDIR)/guessed.mk

# The previous call to 'guess' has already done this.
IGNORE_DEPMOD := 1

.PHONY: create pack install genimage

create: depmod-host
	@$(VMSG) "Creating initrd image ..."
	@mkdir -m 755 -p $(verbose) -- $(ROOTDIR)
	@$(TOOLSDIR)/create-initrd

pack: create
	@$(VMSG) "Sorting sysvinit services ..."
	@$(TOOLSDIR)/sort-services --rcdir="$(ROOTDIR)/etc/rc.d" "$(ROOTDIR)/etc/rc.d/init.d"
	@$(VMSG) "Packing image to archive ..."
	@$(TOOLSDIR)/pack-image

install: pack
	@$(MSG) 'Used features: $(USED_FEATURES)'
	@$(MSG_N) 'Packed modules: '
	@find $(ROOTDIR)/lib/modules/$(KERNEL) -type f \( -name '*.ko'  -o -name '*.ko.*' \) -printf '%f\n' 2>/dev/null | \
	    sed -e 's/\.ko\(\.[^\.]\+\)\?$$//' | sort -u | tr '\n' ' '
	@printf '\n'
	@if [ -f "$(TEMPDIR)/images" ] && grep -Fxqs "$(IMAGEFILE)" "$(TEMPDIR)/images"; then \
	    echo ""; \
	    echo "An attempt to create two images with the same name. There is possibility" >&2; \
	    echo "that you forgot to define IMAGE_SUFFIX or IMAGEFILE in one of the config files." >&2; \
	    echo "" >&2; \
	    echo "ERROR: Unable to overwrite the image $(IMAGEFILE)" >&2; \
	    echo "" >&2; \
	    exit 1; \
	else \
	    $(VMSG) "Installing image ..."; \
	    $(MSG) "Unpacked size: `du -sh "$(WORKDIR)" |cut -f1 ||:`"; \
	    $(MSG) "Image size: `du -sh "$(WORKDIR)/initrd.img" |cut -f1 ||:`"; \
	    chmod 600 -- "$(WORKDIR)/initrd.img"; \
	    mv -f $(verbose) -- "$(WORKDIR)/initrd.img" "$(IMAGEFILE)"; \
	    echo "$(IMAGEFILE)" >> "$(TEMPDIR)/images"; \
	fi

genimage: install
	@$(MSG) "Image is saved as $(IMAGEFILE)"
	@echo

ALL_FEATURES         := $(call get-all-features)
ALL_DISABLE_FEATURES := $(call get-all-disable-features)
ALL_ACTIVE_FEATURES  := $(call get-all-active-features)

ifdef VERBOSE
$(info FEATURES              : $(sort $(FEATURES)))
$(info ALL FEATURES          : $(ALL_FEATURES))
$(info ALL DISABLED FEATURES : $(ALL_DISABLE_FEATURES))
$(info ALL ACTIVE FEATURES   : $(ALL_ACTIVE_FEATURES))
endif

# Load requested features
$(call include-features-once,$(sort $(ALL_ACTIVE_FEATURES)))

endif # MAKECMDGOALS = genimage

.PHONY: all process-config guess-config guess-modules feature-info bug-report

all: check-for-root
	@for c in $(INITRD_CONFIG_LIST); do \
	    $(MAKE) $(MFLAGS) -f /usr/share/make-initrd/mk/make-initrd.mk \
	       process-config INITRD_CONFIG="$$c" || { rc=1; break; }; \
	done; \
	rm -f -- $(TEMPDIR)/images; \
	exit $$rc

process-config: $(INITRD_CONFIG)
	@$(MSG) "Config file: $(INITRD_CONFIG)"
	@$(MAKE) $(MFLAGS) -f /usr/share/make-initrd/mk/make-initrd.mk guess
	@$(MAKE) $(MFLAGS) -f /usr/share/make-initrd/mk/make-initrd.mk genimage

guess-config: check-for-root guess
	@cat $(GUESSDIR)/guessed.mk >&4
	$Qrm -rf -- "$(GUESSDIR)"
	$Qrmdir -- "$(WORKDIR)"

guess-modules: check-for-root guess
	@for f in $(GUESSDIR)/guess:modules* $(GUESSDIR)/guess:modalias*; do \
		[ ! -s "$$f" ] || cat "$$f"; \
	done | \
	   depinfo \
	      --input=- \
	      $(if $(USE_MODPROBE_BLACKLIST),--use-blacklist) \
	      --set-version="$(KERNEL)" \
	      --no-prefix \
	      --no-firmware \
	      --no-builtin \
	      2>/dev/null | \
	   sort -u >&4
	$Qrm -rf -- "$(GUESSDIR)"
	$Qrmdir -- "$(WORKDIR)"

test-guess:
	@$(MAKE) $(MFLAGS) -f /usr/share/make-initrd/mk/make-initrd.mk test-guess-actions
	$Qrm -rf -- "$(GUESSDIR)"
	$Qrm -rf -- "$(WORKDIR)"

ifneq "$(filter show-feature-info,$(MAKECMDGOALS))" ''
INITRD_CONFIG = /dev/null

.PHONY: $(INITRD_CONFIG)

include /usr/share/make-initrd/mk/config.mk
$(call show-feature-dependency,$(FEATURE_NAMES))

.PHONY: show-eature-info

show-feature-info:
	@:
endif

.PHONY: feature-info

feature-info:
	@$(MAKE) $(MFLAGS) -f /usr/share/make-initrd/mk/make-initrd.mk show-feature-info

bug-report: check-for-root
	@mkdir -m 755 -p -- $(REPORTDIR)
	@$(TOOLSDIR)/bug-report >&4
	$Qrm -rf -- "$(REPORTDIR)"
	$Qrmdir -- "$(WORKDIR)"
