#!/bin/bash
###
### This file is covered by the GNU General Public License
### version 3 or later.
###
### Copyright (C) 2021-2025, ALT Linux Team

#############################
### file protocol handler ###
#############################

# Outputs a list of additional required tools
#
get_proto_requires()
{
	echo "stat"
}

# Returns 0 if write operations are allowed on the remote side
#
have_write_access()
{
	[ -w "$backup"/META.tgz ]
}

# Returns 0 if the specified directory exists on the remote side
#
dir_exists()
{
	[ -d "$backup/$1" ]
}

# Returns 0 if the specified file on the remote side is not empty
#
file_exists()
{
	[ -s "$backup/$1" ]
}

# Displays the specified file size (in bytes) if it exists on the remote side
#
get_file_size()
{
	[ ! -r "$backup/$1" ] || run stat -L --printf="%s" -- "$backup/$1"
}

# Creates the specified directory on the remote side
#
create_directory()
{
	run mkdir -p -m 0700 $verbose -- "$backup/$1"
}

# Reads the specified file on the remote side and writes it to stdout
#
read_file()
{
	run cat -- "$backup/$1"
}

# Writes to the specified file on the remote side, reads it from stdin
#
write_file()
{
	cat >"$backup/$1"
}

