#!/bin/bash
###
### This file is covered by the GNU General Public License
### version 3 or later.
###
### Copyright (C) 2021-2025, ALT Linux Team

#############################################
### Supplemental code for Profile Manager ###
#############################################

# Displays a fatal error message and exit
#
fatal()
{
	local fmt="$1"; shift

	printf "%s fatal: $fmt\n" "$progname" "$@" >&2
	exit 1
}

# Unexpected Error Handler
#
unexpected_error()
{
	fatal "Unexpected error #%s catched in %s[#%s]." "$?" "$1" "$2"
}

# Special trick: stub to ignore user-defined hook calls
#
track_hook()
{
	: # Do nothing
}

# Special trick: stub to ignore debugging
#
dbg()
{
	: # Do nothing
}

# Special trick: stub to ignore command logging
#
run()
{
	"$@"
}

# Replaces unsafe characters for using a string in regular expressions
#
safe_regex()
{
	echo "$1" |sed -E 's/([+-.])/\\\1/g'
}

# Checks the validity of the specified date and optional time
# and returns its value in normalized form: YYYY-MM-DD hh:mm:ss
#
normalize_datetime()
{
	local YYYY="[12][0-9][0-9][0-9]"
	local MM="[0-1][0-9]"
	local DD="[0-3][0-9]"
	local hh="[0-2][0-9]"
	local mm="[0-5][0-9]"
	local ss="[0-5][0-9]"

	case "$1" in
	$YYYY-$MM-$DD" "$hh:$mm:$ss)
		printf "%s" "$1"
		;;
	$YYYY-$MM-$DD)
		printf "%s %s" "$1" "$(env LC_TIME=C date -u +%T)"
		;;
	$hh:$mm:$ss)
		printf "%s %s" "$(env LC_TIME=C date -u +%F)" "$1"
		;;
	$hh:$mm)
		printf "%s %s:00" "$(env LC_TIME=C date -u +%F)" "$1"
		;;
	esac
}

# Checks if the profile exists
#
check_profile()
{
	[ -n "$profile" ] ||
		profile="$(machine_profile)"
	[ -s "$backup/profiles/@$profile"/SHARED ] ||
	[ -s "$backup/profiles/$profile"/PROFILE ] ||
		exit 1
}

