#!/bin/bash
###
### This file is covered by the GNU General Public License
### version 3 or later.
###
### Copyright (C) 2021-2025, ALT Linux Team

##################################
### Profile deletion functions ###
##################################

# Deletes the profile and and all links to it
#
remove_profile()
{
	[ -n "$profile" ] ||
		profile="$(machine_profile)"
	local u x p="$backup/profiles/@$profile"

	if [ -s "$p"/SHARED ]; then
		x="$(sed -n '5,$p' "$p"/SHARED |grep -scE "^USED\-BY: " ||:)"
		u="Can't remove shared profile '%s' while it has child profiles."
		[ "$x" = 0 ] ||
			fatal "$u" "$profile"
	else
		p="$backup/profiles/$profile"
		[ -s "$p"/PROFILE ] ||
			fatal "Profile '%s' not found." "$profile"
		u="$(head -n6 -- "$p"/PROFILE |
				sed -n -e 's/^CLASSID: //p' |
				tail -n1)"
		x="$(head -n1 -- "$p"/PARENT 2>/dev/null ||:)"
		[ -z "$x" ] || [ ! -s "$backup/profiles/@$x"/SHARED ] ||
			sed -i -e "/^USED\-BY: $(safe_regex "$u")$/d" \
				"$backup/profiles/@$x"/SHARED
		[ ! -s "$catalog" ] ||
			sed -i -e "/^${u//-/} /d" "$catalog"
	fi

	cd -- "$backup"/
	rm -vrf -- "$p" >&2
}

