#!/bin/bash
###
### This file is covered by the GNU General Public License
### version 3 or later.
###
### Copyright (C) 2021-2025, ALT Linux Team

############################################
### Search and profile listing functions ###
############################################

# Shows a list of all existing profiles
#
list_profiles()
{
	local s p text="${1-}"

	[ -d "$backup"/profiles ] ||
		return 0
	cd -- "$backup"/profiles/

	__full_text_search()
	{
		[ -n "$text" ] ||
			return 0
		( local p="${1%/*}"

		  cat -- "$1"
		  printf "%s\n" "$profile"
		  [ ! -s "$p"/sysrest.ini ] ||
			cat -- "$p"/sysrest.ini
		  [ ! -s "$p"/hooks.sh ] ||
			cat -- "$p"/hooks.sh
		  [ ! -s "$p"/chroot-pre.sh ] ||
			cat -- "$p"/chroot-pre.sh
		  [ ! -s "$p"/chroot-post.sh ] ||
			cat -- "$p"/chroot-post.sh
		) |grep -qs -- "$text"
	}

	# List only shared profiles
	find . -maxdepth 2 -type f -path './@*/SHARED' |sort |
	while read -r profile; do
		profile="${profile:3}"
		profile="${profile%%/SHARED}"
		p="$backup/profiles/$profile"
		s="$backup/profiles/@$profile"
		__full_text_search "$s"/SHARED ||
			continue
		comment="$(head -n3 -- "$s"/SHARED |
					sed -n 's/^COMMENT: //p' |
					tail -n1)"
		[ -n "$comment" ] ||
			comment="$shared_comment"
		[ ! -f "$p"/SHARED  ] &&
		[ ! -f "$s"/PROFILE ] && [ ! -f "$s"/PARENT ] &&
		[ ! -f "$p"/PROFILE ] && [ ! -f "$p"/PARENT ] ||
			comment="!!!INVALID SHARED PROFILE!!!"
		datetime="$(head -n3 -- "$s"/SHARED |
					sed -n 's/^CREATED: //p' |
					tail -n1)"
		printf "%s|@%s|%s\n" "$datetime" "$profile" "$comment"
	done

	# List only regular profiles
	while [ -s "$catalog" ] && read -r s profile; do
		p="$backup/profiles/$profile"
		s="$backup/profiles/@$profile"
		[ -s "$p"/PROFILE  ] &&
		[ ! -f "$p"/SHARED ] &&
		[ ! -f "$s"/SHARED ] ||
			continue
		__full_text_search "$p"/PROFILE ||
			continue
		comment="$(head -n6 -- "$p"/PROFILE |
					sed -n 's/^COMMENT: //p' |
					tail -n1)"
		[ -n "$comment" ] ||
			comment="$(head -n6 -- "$p"/PROFILE |
					sed -n 's/^MACHINE: //p' |
					tail -n1)"
		datetime="$(head -n6 -- "$p"/PROFILE |
					sed -n 's/^CREATED: //p' |
					tail -n1)"
		printf "%s|^%s|%s\n" "$datetime" "$profile" "$comment"
	done <"${catalog:-/dev/null}"

	cd - >/dev/null
	unset __full_text_search
}

# Full-text search of profiles
#
search_profile()
{
	list_profiles "$search"
}

