#!/bin/bash
###
### This file is covered by the GNU General Public License
### version 3 or later.
###
### Copyright (C) 2021-2025, ALT Linux Team

##################################################
### Public settings for deployment and restore ###
##################################################

# Text for the program banner
product_title="ALT Linux Deployment System"

# Version of backup rootfs images and deployment system
# in numeric format MAJOR.MINOR, "1.0" by default
#
release=1.0

# Path to the deployment RELEASE file on the target system:
# leave blank to disable saving this file
#
release_file=/etc/rootfs-release

# The deployment profile name
profile=

# 1: profiles are required
profile_required=

# Empty value to use the deployment system with any hardware,
# or the baremetal name read from the MACHINE field of the
# profile to restrict the deployment system to use only with
# the specified hardware
#
restrict_hardware=

# Device name of the target whole disk
# (optional, it will be auto-detected by default)
#
target=

# Part of the target whole disk device name: vendor and model
# (optional), for example: "SAMSUNG_MZVL21T0HCLR", see it in
# /dev/disk/by-id/
#
target_model=

# Minimum size of each target device for auto-detection,
# empty value (by default) to calculate this value as
# the sum of the sizes of all used partitions
#
min_target_size=

# Maximum size of each target device for auto-detection,
# empty value (by default) when upper limit is not used
#
max_target_size=

# Additional devices list for write protection while search
# the target disk drive, restore or deployment the system
#
protected_devices=

# 1: enables display of the target device selection dialog
choose_target=

# How to create a unique hostname? Available algorithms:
# - copy: do not modify the original template, just copy it "as is";
# - ip1: append the last (4th) part of the IP-address to the base name;
# - ip2: append the two last (3rd and 4th) parts of the IP-address;
# - ip3: append the three last (2nd...4th) parts of the IP-address;
# - hw6: append some hex digits from the Ethernet MAC-address;
# - rnd: generate a random part and append it to the base name;
# - <hook>: use a user-defined host naming function.
# The default value for deployment is "hw6".
#
hostnaming=hw6

# Computer name inside original rootfs backup (will be
# extracted from backup metadata: ORGHOST, by default)
#
template=

# The target computer base name (required)
computer=host

# Single wired interface name in the original rootfs (optional)
oldifname=eth0

# Single wired interface name in the target system (optional)
newifname=

# Basic arguments for running the Linux kernel on the target system,
# empty (by default): arguments will be read from the original rootfs
#
bootargs=

# Additional arguments for running the Linux kernel on Elbrus
e2kadd_bootargs="console=ttyS0,115200 console=tty0 hardreset"

# Space separated list of the Linux kernel flavours for hardware
# specilization in the target system: this list required and
# cannot be empty
#
kernel_flavours="std-def un-def"

# A space separated list of package patterns to install
#
install_packages="*.rpm"

# 1: disable to remove host-based SSH keys from the target system
keep_ssh_host_keys=

# 1: disable the "Suspend to RAM" button inside the target system
no_suspend=

# 1: disable the "Hibernation" button inside the target system
no_hibernate=

# List of OEM Setup (alterator-setup) wizard steps, separated by spaces
oem_setup_steps=

# A space separated list of users to remove at the beginning of the chroot
remove_users=

# A space separated list of packages to remove at the beginning of chroot
remove_packages=

# A space separated list of kernels to remove at before exiting chroot
remove_kernels=

# A space separated list of users to create in the chroot,
# passwords are optional and can be specified after a colon (':')
#
create_users=

# A comma separated list of groups that the
# created user will be included in by default
#
default_groups=

# Space separated list of users to recreate from /etc/skel
cleanup_homedir=

# Password of the only unprivileged user to change
user_password=

# New root password to change
root_password=

# A space separated list of systemd services to enable
enable_services=

# A space separated list of systemd services to disable
disable_services=

# 1: disable write to NVRAM before finish restore (this is useful
# if NVRAM is not supported by efibootmgr on the given hardware),
# empty (by default): enable write to NVRAM in UEFI boot mode
#
no_nvram=

# 1: do not clear NVRAM before saving new record in UEFI boot mode
no_clear_nvram=

# 1: also install the standard boot image to the /EFI/BOOT directory
safe_uefi_boot=1

# How to disk(s) partitioning? Available options are:
#
# - plain:       single drive DOS/MBR or GUID/GPT layout
# - <other>:     user-defined partitioner
#
partitioner=plain

# 1: use "-O ^64bit options with mke2fs >= 1.43 when formatting bootable
# device (root or /boot partition) for better compatibility with some
# trusted boot hardware and Linux kernels 3.x
#
old_ext4_boot=

# 1: force use of GUID/GPT partitioning scheme
force_gpt=

# 1: force use of DOS/MBR partitioning scheme
force_mbr=

# 1: force ESP preparation and use of grub-efi bootloader
force_esp=

# 1: add Legacy/CSM boot mode support on x86_64 with UEFI boot
biosboot_too=

# IBM Power PReP partition size (optional)
prepsize=

# EFI System partition size (optional)
esp_size=

# BIOS Boot partition size (optional)
bbp_size=

# /boot partition size (required only on Elbrus, optional on all other)
bootsize=

# SWAP partition size (optional, can be "AUTO" for auto-detection)
swapsize=

# / (system root) partition size (optional)
rootsize=

# Default GUID/GPT partition names
#
prep_gpt_label=PReP
esp__gpt_label=ESP
bbp__gpt_label=GRUB
boot_gpt_label=BOOT
swap_gpt_label=SWAP
root_gpt_label=ROOT
data_gpt_label=DATA

# Default filesystem volume labels
#
esp__fs_label=ESP
boot_fs_label=BOOT
swap_fs_label=SWAP
root_fs_label=ROOT
data_fs_label=DATA

# User data partition mount point, if used
datapart_mp=/home

# Mount options for ESP (EFI System Partition)
esp_opts="umask=0,quiet,showexec,iocharset=utf8,codepage=866"

# Mount options for partition / (system root)
rootopts="relatime"

# Mount options for a separate /boot partition
bootopts="nosuid,relatime"

# Mount options for /home or /var partition (user data)
dataopts="nosuid,relatime"

