#!/bin/bash
###
### This file is covered by the GNU General Public License
### version 3 or later.
###
### Copyright (C) 2021-2025, ALT Linux Team

##########################################################
### Internal variables. Don't use them in sysrest.ini! ###
##########################################################

# Console colors
CLR_NORM="\033[00m"
CLR_BOLD="\033[01;37m"
CLR_LC1="\033[00;36m"
CLR_LC2="\033[01;35m"
CLR_OK="\033[00;32m"
CLR_ERR="\033[01;31m"
CLR_WARN="\033[01;33m"

# The specified action name (required)
action=

# The final action, empty by default: do nothing, just exit;
# "reboot": reboot the computer after successful recovery;
# "poweroff": turn off power after successful recovery.
#
finalact=

# Backup directory on local file system
# (by default this is the current working directory)
#
backup="$(realpath .)"

# Remote backup storage account information
backup_proto=file

# Non-empty (by default): check the backup and metadata
use_backup=1

# Directory with the profile data (auto-detected in run-time)
profile_subdir=

# Hardware ID when deploying or restoring to bare metal
baremetal=

# Target disk information (auto-detected in run-time)
diskinfo=

# Hardware platform name (auto-detected in run-time)
platform=

# Temporary working directory (created in run-time)
workdir=

# Empty by default: deployment or restore on the bare metal,
# hypervisor name: we are working inside hypervisor like KVM
# (auto-detected in run-time)
#
hypervisor=

# Creating disk label type (auto-detected in run-time)
# "dos": DOS/MBR partitioning scheme will be used
# "gpt": GUID/GPT partitioning scheme will be used
#
pt_scheme=gpt

# Boot file name in UEFI boot mode (auto-detected in run-time)
uefiboot=

# Platform-specific EFI binary suffix (auto-detected in run-time)
efi_suffix=

# Auto-detected names of the partition devices
# (only $rootpart is strictly required by default)
#
# $preppart used for install grub-ieee1275 on IBM Power
# $bbp_part used for install grub-pc to GUID/GPT disk label
# $esp_part used for /boot/efi (required for UEFI boot mode)
# $bootpart used for /boot (required only on e2k* platforms)
# $swappart used for SWAP and hibernation mode support
# $rootpart used for / (rootfs always required)
# $datapart used for /home or /var (user data)
#
preppart=
esp_part=
bbp_part=
bootpart=
swappart=
rootpart=
datapart=

# File system UUIDs
#
bootuuid=
swapuuid=

# Use or not "p" delimiter between the target device name and
# the partition number: it will be auto-detected in run-time
#
ppartsep=

# 1: enable deployment or restore on removable devices
use_removable=

# 1: enable "quiet" mode on stdout, disabled by default
quiet=

# 1: enable "verbose" mode on stderr, disabled by default
verbose=

# 1: enable interaction with the alterator browser
alterator=

# Full name of FIFO for interaction with another frontend
frontend_pipe=

# Syslog priority, empty: do not use syslog
logprio=user.info

# Full path to the log file, empty path disables logging
logfile="/var/log/$progname.log"

# Ability to import SYSREST_DEBUG option from environment
SYSREST_DEBUG="${SYSREST_DEBUG-}"

# 1: include PCI bus information when creating machine UUID
pci_bus=1

# 1: include unique instance information in machine UUID
instance=

# Empty (by default): enable to use user-defined hooks
# and scripts supplied with the backup and/or profile
#
disable_hooks=

# Temporary mount point for restoring rootfs and chroot
readonly destdir=/mnt/target

# EFI Bootloader ID
readonly bootldr_id=altlinux

# IBM Power PReP partition GUID for grub-ieee1275 only
readonly prepguid="9E1A2D38-C612-4316-AA26-8B49521E5A8B"

# BIOS Boot partition GUID for grub-pc only
readonly bbp_guid="21686148-6449-6E6F-744E-656564454649"

# Initial mount points for auto-detecting write-protected devices
protected_mpoints="/ /image /mnt/autorun /mnt/backup"

