
/*
  $Id: commitlogger.c,v 1.14 2004/05/26 15:23:59 ldv Exp $
  Copyright (C) 2004  Dmitry V. Levin <ldv@altlinux.org>

  The commitlogger program.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#define _GNU_SOURCE

#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
#include <pwd.h>

#include "xmalloc.h"
#include "split.h"
#include "filter.h"
#include "diff.h"
#include "message.h"
#include "send.h"

static void
sigchld_handler ( __attribute__ ((unused))
		 int signo)
{
	while (waitpid (-1, 0, WNOHANG) > 0)
		;
}

int
main (int ac, const char *av[])
{
	uid_t   uid = geteuid ();

	if (!uid)
		error (EXIT_FAILURE, 0, "must be non-root");

	struct passwd *pw = getpwuid (uid);

	if (!pw)
		error (EXIT_FAILURE, errno, "getpwuid");

	const char *username = pw->pw_name;

	if (!username || !*username)
		error (EXIT_FAILURE, 0, "invalid username");

	if (3 != ac)
		error (EXIT_FAILURE, 0, "invalid arguments");

	if (strcmp ("-c", av[1]))
		error (EXIT_FAILURE, EINVAL, "%s", av[1]);

	const char *cmd = av[2];
	int     argc;
	const char **argv = split_cmd (cmd, &argc);

	if (argc < 4)
		error (EXIT_FAILURE, 0, "insufficient arguments");

	const char *in_dir;
	const char *header = make_header (username, &in_dir, &argc, &argv);

	sendmail_init ();
	sendmail_write (header);
	sendmail_redirect ();

	if (daemon (1, 1))
		error (EXIT_FAILURE, errno, "daemon");
	if (chdir ("/tmp"))
		error (EXIT_FAILURE, errno, "chdir");
	sleep (1);

	signal (SIGCHLD, sigchld_handler);

	const char *body = make_body (in_dir, cmd, argc, argv);
	sendmail_write (body);

	return EXIT_SUCCESS;
}
