#!/bin/sh

export LANG=C
export LANGUAGE=C
export LC_ALL=C

trap '' HUP

if [ -z "$FORKED" ]; then
	COMMIT=`mktemp -t commitlogger.XXXXXX` || exit 1
	sed "s, $CVSROOT, ," | grep -v '^In directory ' > $COMMIT
	echo >> $COMMIT
	COMMIT=$COMMIT FORKED=1 $0 $* &
	exit 0
fi

DIFF1=`mktemp -t commitlogger.XXXXXX` || exit 1
DIFFS=`mktemp -t commitlogger.XXXXXX` || exit 1
trap "rm -f $COMMIT $DIFF1 $DIFFS" EXIT INT TERM

sleep 1

CVSR="$CVSROOT/CVSROOT"
USER="`whoami`"
NAME="$CVSROOT - $USER"
FROM="${USER}@office.altlinux.org"
TO="$1"
shift
DIR="$1"
MODULE="$(echo -n "$DIR" |cut -d/ -f1)"
SUBJECT="[cvs commit] $DIR"

CHARSET_CONF="$CVSR/commitlogger-charset.conf"

DIFFMAX=16384

if [ "$2 $3 $4" = "- New directory" ]; then
	echo "New directory: \"$DIR\"" >> $DIFFS
	shift 3
elif [ "$2 $3 $4" = "- Imported sources" ]; then
	echo "Imported sources: \"$DIR\"" >> $DIFFS
	shift 3
fi

CHARSET="`sed -n "s,^${DIR}:,,p" < $CHARSET_CONF`"
test -n "$CHARSET" || CHARSET="koi8-r"

while [ $# -gt 1 ]; do
	shift
	FILESPEC="$1"
	FILE="`echo "$FILESPEC" | cut -f1 -d,`"
	REV1="`echo "$FILESPEC" | cut -f2 -d,`"
	REV2="`echo "$FILESPEC" | cut -f3 -d,`"
	if [ "$REV1" = "NONE" ]; then
		echo "New file: \"$FILE\"" >> $DIFFS
		continue
	fi
	if [ "$REV2" = "NONE" ]; then
		echo "Removed file: \"$FILE\"" >> $DIFFS
		continue
	fi
	cvs -f rdiff -u -r "$REV1" -r "$REV2" "$DIR/$FILE" \
		< /dev/null &> $DIFF1
	SIZE="`wc -c $DIFF1 | sed 's/^[^0-9]*\([0-9]*\).*$/\1/'`"
	if [ $SIZE -ge $DIFFMAX ]; then
		echo "Diffs for \"$FILE\" too large ($SIZE bytes)" >> $DIFFS
	else
		cat $DIFF1 >> $DIFFS
	fi
done

if [ -w "$CVSR/$MODULE/commitlog" ]; then
	COMMITLOG="$CVSR/$MODULE/commitlog"
else
	COMMITLOG="$CVSR/commitlog"
fi

cat << EOF >> "$COMMITLOG"
----------
`date` :: $FROM

`cat $COMMIT $DIFFS`

EOF

if [ -n "$TO" ]; then
	/usr/sbin/sendmail -i -t << EOF
To: $TO
Subject: $SUBJECT
Content-Type: text/plain; charset=$CHARSET
X-CVSROOT: $CVSROOT

`cat $COMMIT $DIFFS`

EOF
fi
