
/*
  $Id: filter.c,v 1.1 2004/05/23 18:24:51 ldv Exp $
  Copyright (C) 2004  Dmitry V. Levin <ldv@altlinux.org>

  The stream filters for the commitlogger program.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#define _GNU_SOURCE

#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "filter.h"

void
copy_in_out (FILE * in, FILE * out)
{
	char   *line = NULL;
	size_t  len = 0;
	ssize_t rc;

	while ((rc = getline (&line, &len, in)) != -1)
		fputs (line, out);

	if (ferror (in))
		fprintf (out, "getline: %s\n", strerror (errno));

	free (line);
}

void
filter_log (FILE * in, FILE * out)
{
	char   *line = NULL;
	size_t  len = 0;
	ssize_t rc;
	int     find = 1;

	while ((rc = getline (&line, &len, in)) != -1)
	{
		const char prefix[] = "In directory ";

		if (find && !strncmp (line, prefix, sizeof (prefix) - 1))
		{
			find = 0;
			continue;
		}
		fputs (line, out);
	}
	if (ferror (in))
		fprintf (out, "getline: %s\n", strerror (errno));

	free (line);
}
