
/*
  $Id: message.c,v 1.4 2004/05/26 14:55:20 ldv Exp $
  Copyright (C) 2004  Dmitry V. Levin <ldv@altlinux.org>

  The message generator for the commitlogger program.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#define _GNU_SOURCE

#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "filter.h"
#include "diff.h"
#include "message.h"

#define PATH_SOCKET "/dev/sendmail"

const char *
make_header (const char *from, const char **in_dir, int *argc,
	     const char ***argv)
{
	char   *buffer;
	size_t  size;
	FILE   *stream = open_memstream (&buffer, &size);

	if (!stream)
		error (EXIT_FAILURE, errno, "open_memstream");

	const char **saved_argv = *argv;
	const char *address = ((*argv)++)[0];
	const char *charset = ((*argv)++)[0];

	*in_dir = ((*argv)++)[0];
	(*argc) += (saved_argv - *argv);

	fprintf (stream, "From: %s@localhost\n", from);
	fprintf (stream, "To: %s\n", address);
	fprintf (stream, "Subject: [cvs commit] %s\n", *in_dir);
	fprintf (stream, "Content-Type: text/plain; charset=%s\n", charset);
	fprintf (stream, "X-CVSROOT: %s\n", getenv ("CVSROOT") ? : "");
	fputc ('\n', stream);

	filter_log (stdin, stream);
	fputc ('\n', stream);

	fclose (stream);
	return buffer;
}

const char *
make_body (const char *in_dir, const char *cmd, int argc, const char **argv)
{
	char   *buffer;
	size_t  size;
	FILE   *stream = open_memstream (&buffer, &size);

	if (!stream)
		error (EXIT_FAILURE, errno, "open_memstream");

	int     i = 0;

	if (!strcmp ("-", argv[i]))
	{
		if (argc < i + 3)
			error (EXIT_FAILURE, EINVAL, "%s", cmd);

		if ((!strcmp ("New", argv[i + 1])
		     && !strcmp ("directory", argv[i + 2]))
		    || (!strcmp ("Imported", argv[i + 1])
			&& !strcmp ("sources", argv[i + 2])))
		{
			fprintf (stream, "%s %s: %s\n", argv[i + 1],
				 argv[i + 2], in_dir);
			i += 3;
		} else
			error (EXIT_FAILURE, EINVAL, "%s", cmd);
	}

	struct diff diff[argc];

	memset (diff, 0, sizeof (diff));

	for (; i < argc; ++i)
		print_diff (stream, in_dir, argv[i], &diff[i]);
	fputc ('\n', stream);

	for (i = 0; i < argc; ++i)
		if (diff[i].buffer)
			fprintf (stream, "%s", diff[i].buffer);

	fclose (stream);
	return buffer;
}
