
/*
  $Id: send.c,v 1.4 2004/05/26 15:21:46 ldv Exp $
  Copyright (C) 2004  Dmitry V. Levin <ldv@altlinux.org>

  The sender for the commitlogger program.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#define _GNU_SOURCE

#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "send.h"

#define PATH_SOCKET "/dev/sendmail"

static int
write_loop (int fd, const char *buffer, size_t count)
{
	ssize_t offset = 0;

	while (count > 0)
	{
		ssize_t block = write (fd, &buffer[offset], count);

		if (block < 0)
		{
			if (errno == EINTR)
				continue;
			return block;
		}
		if (!block)
			break;
		offset += block;
		count -= block;
	}
	return offset;
}

int     sm_fd = -1;

void
sendmail_init (void)
{
	sm_fd = socket (PF_UNIX, SOCK_STREAM, 0);

	if (sm_fd < 0)
		error (EXIT_FAILURE, errno, "socket");

	struct sockaddr_un sun;

	memset (&sun, 0, sizeof (sun));
	sun.sun_family = AF_UNIX;
	strcpy (sun.sun_path, PATH_SOCKET);

	if (connect (sm_fd, (struct sockaddr *) &sun, sizeof (sun)))
		error (EXIT_FAILURE, errno, "connect: %s", PATH_SOCKET);
}

void
sendmail_write (const char *text)
{
	int     len = strlen (text);

	if (write_loop (sm_fd, text, len) != len)
		error (EXIT_FAILURE, errno, "write: %s", PATH_SOCKET);
}

void
sendmail_redirect (void)
{
	fflush (stdout);
	fflush (stderr);
	dup2 (sm_fd, STDOUT_FILENO);
	dup2 (sm_fd, STDERR_FILENO);
	setlinebuf (stdout);
	setlinebuf (stderr);
}
