
/*
  $Id: split.c,v 1.1 2004/05/23 17:39:38 ldv Exp $
  Copyright (C) 2004  Dmitry V. Levin <ldv@altlinux.org>

  The argument splitter for the commitlogger program.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#define _GNU_SOURCE

#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "xmalloc.h"
#include "split.h"

const char **
split_cmd (const char *cmd, int *argc)
{
	const char *p;
	const char **argv = 0;

	(*argc) = 0;
	char    buf[strlen (cmd) + 1];
	int     i = 0;

	for (p = cmd; *p; ++p)
	{
		if (isblank (*p))
		{
			if (i > 0)
			{
				buf[i] = '\0';
				i = 0;
				argv = xrealloc (argv,
						 ((*argc) +
						  1) * sizeof (argv[0]));
				argv[(*argc)++] = xstrdup (buf);
			}

			continue;
		}

		if ('"' == *p)
			continue;

		if ('\\' == *p)
		{
			++p;
			if (!*p)
				break;
		}

		if (isspace (*p) || !isprint (*p))
			error (EXIT_FAILURE, EINVAL, "%s", cmd);

		buf[i++] = *p;
	}

	if (i > 0)
	{
		buf[i] = '\0';
		i = 0;
		argv = xrealloc (argv, ((*argc) + 1) * sizeof (argv[0]));
		argv[(*argc)++] = xstrdup (buf);
	}

	return argv;
}
