
/*
  Copyright (C) 2002-2006  Dmitry V. Levin <ldv@altlinux.org>

  The filesystem lists manipulations.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <error.h>
#include <unistd.h>
#include <mntent.h>
#include <paths.h>

#include "lists.h"
#include "xmalloc.h"

long   *list_prune_fstype;

/* Taken from /usr/include/linux/<name>_fs.h */
static struct
{
	long    id;
	const char *name;
} fs_list[] =
{
	{0xadf5, "adfs"},
	{0xadff, "affs"},
	{0x6b414653, "afs"},
	{0x187, "autofs"},
	{0x42465331, "befs"},
	{0x1badface, "bfs"},
	{0x434e, "capifs"},
	{0xff534d42, "cifs"},
	{0x73757245, "coda"},
	{0x12ff7b7, "coh"},
	{0x62656570, "configfs"},
	{0x28cd3d45, "cramfs"},
	{0x64626720, "debugfs"},
	{0x1373, "devfs"},
	{0x1cd1, "devpts"},
	{0x414a53, "efs"},
	{0x137d, "ext"},
	{0xef51, "ext2"},
	{0xef53, "ext2"},
	{0xef53, "ext3"},
	{0x4d44, "fat"},
	{0x65735546, "fuse"},
	{0x4244, "hfs"},
	{0x482b, "hfsplus"},
	{0xc0ffee, "hostfs"},
	{0xf995e849, "hpfs"},
	{0xb00000ee, "hppfs"},
	{0x958458f6, "hugetlbfs"},
	{0x9660, "iso9660"},
	{0x9660, "isofs"},
	{0x72b6, "jffs2"},
	{0x3153464a, "jfs"},
	{0x137f, "minix"},
	{0x138f, "minix"},
	{0x2468, "minix2"},
	{0x2478, "minix2"},
	{0x4d44, "msdos"},
	{0x564c, "ncp"},
	{0x6969, "nfs"},
	{0x4d44, "ntfs"},
	{0x9fa1, "openprom"},
	{0x50495045, "pipefs"},
	{0x9fa0, "proc"},
	{0x2f, "qnx4"},
	{0x858458f6, "ramfs"},
	{0x52654973, "reiserfs"},
	{0xf0b4a981, "relayfs"},
	{0x7275, "romfs"},
	{0x2011994, "shmfs"},
	{0x517b, "smb"},
	{0x73717368, "squashfs"},
	{0x62656572, "sysfs"},
	{0x12ff7b6, "sysv2"},
	{0x12ff7b5, "sysv4"},
	{0x1021994, "tmpfs"},
	{0x15013346, "udf"},
	{0x11954, "ufs"},
	{0x19540119, "ufs"},
	{0x4d44, "umsdos"},
	{0x9fa2, "usbdevice"},
	{0x4d44, "vfat"},
	{0xa501fcf5, "vxfs"},
	{0x12ff7b4, "xenix"},
	{0x58465342, "xfs"},
	{0x12fd16d, "xiafs"}
};

size_t fstype_list_size = sizeof(fs_list) / sizeof(fs_list[0]);

static int
long_compare(const long **a, const long **b)
{
	return *a - *b;
}

void
convert_fs_paths(void)
{
	struct mntent *e;
	FILE   *fp;
	unsigned i, j;

	if (!(fp = setmntent(_PATH_MOUNTED, "r")))
		error(EXIT_FAILURE, errno, "%s", _PATH_MOUNTED);

	while ((e = getmntent(fp)))
		for (i = 0; i < size_prune_fs; ++i)
			if (!strcasecmp(e->mnt_type, list_prune_fs[i]))
				add_prune_path(e->mnt_dir);
	endmntent(fp);

	list_prune_fstype =
		xcalloc(fstype_list_size, sizeof(*list_prune_fstype));
	for (i = 0; i < size_prune_fs; ++i)
		for (j = 0; j < fstype_list_size; ++j)
			if (!strcasecmp(list_prune_fs[i], fs_list[j].name))
				list_prune_fstype[j] = fs_list[j].id;

	qsort(list_prune_fstype, fstype_list_size,
	      sizeof(*list_prune_fstype), (comparison_fn_t) long_compare);

	for (i = 0; i < fstype_list_size; i++)
		if (list_prune_fstype[i])
			break;

	list_prune_fstype += i;
	fstype_list_size -= i;
}
