
/*
  Copyright (C) 2002-2006  Dmitry V. Levin <ldv@altlinux.org>

  The list manipulations.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <error.h>

#include "lists.h"
#include "xmalloc.h"

static int
bsearch_compare(const char *a, const char **b)
{
	return strcmp(a, *b);
}

static int
sort_compare(const char **a, const char **b)
{
	return strcmp(*a, *b);
}

static void
add_paths_to_list(const char *cpaths, const char ***plist, size_t *psize)
{
	char   *paths = xstrdup(cpaths);
	char   *token;

	for (token = strtok(paths, ",: "); token; token = strtok(0, ",: "))
	{
		if (!*token)
			continue;

		/* strip trailing slashes */
		{
			int     len = strlen(token) - 1;

			for (; (len > 0) && (token[len] == '/'); --len)
				token[len] = '\0';
		}

		if (*plist && bsearch(token, *plist, *psize, sizeof(**plist),
				      (comparison_fn_t) bsearch_compare))
			continue;

		*plist = (const char **) xrealloc(*plist,
						  ++(*psize) *
						  sizeof(**plist));
		(*plist)[*psize - 1] = token;

		qsort(*plist, *psize,
		      sizeof(**plist), (comparison_fn_t) sort_compare);
	}
}

#define DEFINE_LISTS( arg ) \
void add_##arg (const char *paths) \
{ \
	add_paths_to_list(paths, &list_##arg, &size_##arg); \
} \
const char **list_##arg; \
size_t size_##arg

DEFINE_LISTS(search_paths);
DEFINE_LISTS(prune_path);
DEFINE_LISTS(prune_fs);
