
/*
  Copyright (C) 2006  Dmitry V. Levin <ldv@altlinux.org>

  The locate statistics.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#ifndef LSTATS_H__
#define LSTATS_H__

#include <stdint.h>

typedef struct
{
	uintmax_t compressed_bytes;
	uintmax_t total_filename_count;
	uintmax_t total_filename_length;
	uintmax_t whitespace_count;
	uintmax_t newline_count;
	uintmax_t highbit_filename_count;
	size_t  file_size;
} locate_stats;

extern void
print_stats(locate_stats *stats);

extern void
count_stats(const char *path, locate_stats *stats);

#endif /* LSTATS_H__ */
