
/*
  Copyright (C) 2006  Dmitry V. Levin <ldv@altlinux.org>

  The match methods.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#ifndef MATCH_H__
#define MATCH_H__

#include <stdint.h>
#include <stdbool.h>

typedef struct
{
	uintmax_t limit;
	bool    match_all;
	bool    match_basename;
	bool    check_existence;
	bool    follow_symlinks;
	bool    ignore_case;
	bool    limit_output;
	bool    print_match;
	bool    quiet;
	bool    match_regex;
	bool    print_stats;
	char    separator;
}
locate_settings;

struct match_ctx_struct;
typedef bool (*MATCH_FPTR)(const char *, struct match_ctx_struct *);
typedef struct match_ctx_struct
{
	MATCH_FPTR matcher;
	void   *data;
	bool    ignore_case;
}
match_context;

extern  uintmax_t
locate(int argc, match_context * ctxv, const char *dbfile,
       locate_settings *settings);

extern match_context *
match_init(int argc, char *const *argv, locate_settings *settings);

extern bool
match(int argc, match_context *ctxv, const char *path,
      const char *sample, locate_settings *settings);

extern void
substr_match_init(const char *pattern, match_context *context,
		  locate_settings *settings);

extern void
glob_match_init(const char *pattern, match_context *context,
		locate_settings *settings);

extern void
regex_match_init(const char *pattern, match_context *context,
		 locate_settings *settings);

#endif /* MATCH_H__ */
