
/*
  Copyright (C) 2002-2006  Dmitry V. Levin <ldv@altlinux.org>

  The substr method for locate.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <string.h>

#include "match.h"

static bool
substr_match(const char *sample, match_context *context)
{
	const char *pattern = context->data;

	return (context->ignore_case ? strcasestr : strstr) (sample,
							     pattern) ? true
		: false;
}

void
substr_match_init(const char *pattern, match_context *context,
		  locate_settings *settings)
{
	context->matcher = substr_match;
	context->data = (void *) pattern;
	context->ignore_case = settings->ignore_case;
}
