
/*
  $Id: fstypes.c,v 1.8 2005/12/02 14:33:47 ldv Exp $
  Copyright (C) 2002, 2003, 2005  Dmitry V. Levin <ldv@altlinux.org>

  The filesystem lists manipulations.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <error.h>
#include <unistd.h>
#include <mntent.h>
#include <paths.h>

#include "lists.h"
#include "xmalloc.h"

long   *list_prune_fstype;

/* Taken from /usr/include/linux/<name>_fs.h */
static struct
{
	long    id;
	const char *name;
} fs_list[] =
{
	{0xadf5, "adfs"},
	{0xadff, "affs"},
	{0x73757245, "coda"},
	{0x28cd3d45, "cramfs"},
	{0x1373, "devfs"},
	{0x00414a53, "efs"},
	{0x137d, "ext"},
	{0xef51, "ext2"},
	{0xef53, "ext2"},
	{0xef53, "ext3"},
	{0x4d44, "fat"},
	{0xf995e849, "hpfs"},
	{0x9660, "isofs"},
	{0x9660, "iso9660"},
	{0x72b6, "jffs2"},
	{0x137f, "minix"},
	{0x138f, "minix"},
	{0x2468, "minix2"},
	{0x2478, "minix2"},
	{0x4d44, "msdos"},
	{0x564c, "ncp"},
	{0x6969, "nfs"},
	{0x4d44, "ntfs"},
	{0x9fa1, "openprom"},
	{0x50495045, "pipefs"},
	{0x9fa0, "proc"},
	{0x002f, "qnx4"},
	{0x52654973, "reiserfs"},
	{0x7275, "romfs"},
	{0x517b, "smb"},
	{0x00011954, "ufs"},
	{0x4d44, "umsdos"},
	{0x9fa2, "usbdevice"},
	{0x4d44, "vfat"},
	{0x58465342, "xfs"},
	{0x012fd16d, "xiafs"}
};

size_t fstype_list_size = sizeof(fs_list) / sizeof(fs_list[0]);

static int
long_compare(const long **a, const long **b)
{
	return *a - *b;
}

void
convert_fs_paths(void)
{
	struct mntent *e;
	FILE   *fp;
	unsigned i, j;

	if (!(fp = setmntent(_PATH_MOUNTED, "r")))
		error(EXIT_FAILURE, errno, "%s", _PATH_MOUNTED);

	while ((e = getmntent(fp)))
		for (i = 0; i < size_prune_fs; ++i)
			if (!strcasecmp(e->mnt_type, list_prune_fs[i]))
				add_prune_path(e->mnt_dir);
	endmntent(fp);

	list_prune_fstype =
		xcalloc(fstype_list_size, sizeof(*list_prune_fstype));
	for (i = 0; i < size_prune_fs; ++i)
		for (j = 0; j < fstype_list_size; ++j)
			if (!strcasecmp(list_prune_fs[i], fs_list[j].name))
				list_prune_fstype[j] = fs_list[j].id;

	qsort(list_prune_fstype, fstype_list_size,
	      sizeof(*list_prune_fstype), (comparison_fn_t) long_compare);

	for (i = 0; i < fstype_list_size; i++)
		if (list_prune_fstype[i])
			break;

	list_prune_fstype += i;
	fstype_list_size -= i;
}
