
/*
  $Id: glob.c,v 1.5 2005/12/02 14:21:30 ldv Exp $
  Copyright (C) 2002, 2004, 2005  Dmitry V. Levin <ldv@altlinux.org>

  The glob method for locate.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <stdlib.h>
#include <fnmatch.h>

#include "methods.h"

void   *
glob_open(const char *pattern, __attribute__ ((unused))
	  int icase)
{
	return (void *) pattern;
}

int
glob_match(void *handle, const char *sample, int icase)
{
	const char *pattern = (const char *) handle;
	int     rc = fnmatch(pattern, sample, icase ? FNM_CASEFOLD : 0);

	if (!rc)
		return 1;
	else if (FNM_NOMATCH != rc)
		error(EXIT_FAILURE, errno, "fnmatch");
	return 0;
}
