
/*
  $Id: lists.c,v 1.6 2005/12/02 14:21:30 ldv Exp $
  Copyright (C) 2002, 2003, 2005  Dmitry V. Levin <ldv@altlinux.org>

  The list manipulations.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <error.h>

#include "lists.h"
#include "xmalloc.h"

static int
bsearch_compare(const char *a, const char **b)
{
	return strcmp(a, *b);
}

static int
sort_compare(const char **a, const char **b)
{
	return strcmp(*a, *b);
}

#define DEFINE_LISTS( arg ) \
void \
add_##arg (const char *__paths) \
{ \
	char   *paths = xstrdup (__paths); \
	char   *token; \
\
	for (token = strtok (paths, ",: "); token; token = strtok (0, ",: ")) \
	{ \
		if (!*token) \
			continue; \
\
		{ \
			int     len = strlen (token) - 1; \
\
			for (; (len > 0) && (token[len] == '/'); --len) \
			token[len] = '\0'; \
		} \
\
		if (list_##arg && bsearch(token, list_##arg, size_##arg, \
		    sizeof (*list_##arg), (comparison_fn_t) bsearch_compare)) \
			continue; \
\
		list_##arg = \
			(const char **) xrealloc (list_##arg, \
				  ++size_##arg * sizeof (*list_##arg)); \
\
		list_##arg[size_##arg - 1] = token; \
\
		qsort (list_##arg, size_##arg, \
		       sizeof (*list_##arg), (comparison_fn_t) sort_compare); \
	} \
} \
const char **list_##arg; \
size_t size_##arg

DEFINE_LISTS(search_paths);
DEFINE_LISTS(prune_path);
DEFINE_LISTS(prune_fs);
